/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;

public class ConferenceSchedulingPanel
extends SolutionPanel<ConferenceSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/conferencescheduling/swingui/conferenceSchedulingLogo.png";

    public ConferenceSchedulingPanel() {
        JButton publishButton = new JButton("Publish");
        publishButton.addActionListener(actionEvent -> ((ConferenceSolution)this.solutionBusiness.getSolution()).getTalkList().forEach(talk -> {
            talk.setPublishedTimeslot(talk.getTimeslot());
            talk.setPublishedRoom(talk.getRoom());
        }));
        JButton showInLibreOfficeOrExcelButton = new JButton("Show in LibreOffice or Excel");
        showInLibreOfficeOrExcelButton.addActionListener(event -> {
            File tempFile;
            ConferenceSchedulingXlsxFileIO solutionFileIO = new ConferenceSchedulingXlsxFileIO();
            try {
                tempFile = File.createTempFile(this.solutionBusiness.getSolutionFileName(), "." + solutionFileIO.getOutputFileExtension());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp file.", e);
            }
            solutionFileIO.write((ConferenceSolution)this.solutionBusiness.getSolution(), tempFile);
            try {
                Desktop.getDesktop().open(tempFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to show temp file (" + tempFile + ") in LibreOffice or Excel.", e);
            }
        });
        JPanel showPanel = new JPanel();
        JPanel importPanel = new JPanel();
        showPanel.setLayout(new FlowLayout(0));
        importPanel.setLayout(new FlowLayout(0));
        showPanel.add(showInLibreOfficeOrExcelButton);
        showPanel.add(new JLabel("Changes to that file are ignored unless you explicitly save it there and open it here."));
        importPanel.add(publishButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(2, 1));
        buttonsPanel.add(showPanel);
        buttonsPanel.add(importPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonsPanel, "North");
    }

    @Override
    public void resetPanel(ConferenceSolution solution) {
    }
}

