/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain.contract;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLineType;

public class MinMaxContractLine
extends ContractLine {
    private boolean minimumEnabled;
    private int minimumValue;
    private int minimumWeight;
    private boolean maximumEnabled;
    private int maximumValue;
    private int maximumWeight;

    public MinMaxContractLine() {
    }

    public MinMaxContractLine(long id, Contract contract, ContractLineType contractLineType, boolean minimumEnabled, boolean maximumEnabled) {
        super(id, contract, contractLineType);
        this.minimumEnabled = minimumEnabled;
        this.maximumEnabled = maximumEnabled;
    }

    public boolean isViolated(int count) {
        return this.getViolationAmount(count) != 0;
    }

    public int getViolationAmount(int count) {
        if (this.minimumEnabled && count < this.minimumValue) {
            return (this.minimumValue - count) * this.minimumWeight;
        }
        if (this.maximumEnabled && count > this.maximumValue) {
            return (count - this.maximumValue) * this.maximumWeight;
        }
        return 0;
    }

    public boolean isMinimumEnabled() {
        return this.minimumEnabled;
    }

    public void setMinimumEnabled(boolean minimumEnabled) {
        this.minimumEnabled = minimumEnabled;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(int minimumValue) {
        this.minimumValue = minimumValue;
    }

    public int getMinimumWeight() {
        return this.minimumWeight;
    }

    public void setMinimumWeight(int minimumWeight) {
        this.minimumWeight = minimumWeight;
    }

    public boolean isMaximumEnabled() {
        return this.maximumEnabled;
    }

    public void setMaximumEnabled(boolean maximumEnabled) {
        this.maximumEnabled = maximumEnabled;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue;
    }

    public int getMaximumWeight() {
        return this.maximumWeight;
    }

    public void setMaximumWeight(int maximumWeight) {
        this.maximumWeight = maximumWeight;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return this.minimumEnabled || this.maximumEnabled;
    }
}

