/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.location;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import org.optaplanner.examples.common.persistence.jackson.KeySerializer;
import org.optaplanner.examples.tsp.domain.location.Location;
import org.optaplanner.examples.tsp.domain.location.RoadLocationKeyDeserializer;

public class RoadLocation
extends Location {
    protected Map<RoadLocation, Double> travelDistanceMap;

    public RoadLocation() {
    }

    public RoadLocation(long id) {
        super(id);
    }

    public RoadLocation(long id, double latitude, double longitude) {
        super(id, latitude, longitude);
    }

    @JsonSerialize(keyUsing=KeySerializer.class)
    @JsonDeserialize(keyUsing=RoadLocationKeyDeserializer.class)
    public Map<RoadLocation, Double> getTravelDistanceMap() {
        return this.travelDistanceMap;
    }

    public void setTravelDistanceMap(Map<RoadLocation, Double> travelDistanceMap) {
        this.travelDistanceMap = travelDistanceMap;
    }

    @Override
    public long getDistanceTo(Location location) {
        if (this == location) {
            return 0L;
        }
        double distance = this.travelDistanceMap.get((RoadLocation)location);
        return (long)(distance * 1000.0 + 0.5);
    }
}

