/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.experimental.api.Break;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.common.experimental.api.Sequence;
import org.optaplanner.examples.common.experimental.impl.ConsecutiveSetTree;
import org.optaplanner.examples.common.experimental.impl.IterableList;

class ConsecutiveSetTreeTest {
    ConsecutiveSetTreeTest() {
    }

    private ConsecutiveSetTree<AtomicInteger, Integer, Integer> getIntegerConsecutiveSetTree() {
        return new ConsecutiveSetTree((a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(0));
    }

    private <ValueType_, DifferenceType_ extends Comparable<DifferenceType_>> Break<ValueType_, DifferenceType_> getBreak(ConsecutiveInfo<ValueType_, DifferenceType_> consecutiveData, ValueType_ start, ValueType_ end, DifferenceType_ length) {
        for (Break sequenceBreak : consecutiveData.getBreaks()) {
            if (!sequenceBreak.getPreviousSequenceEnd().equals(start) || !sequenceBreak.getNextSequenceStart().equals(end)) continue;
            return sequenceBreak;
        }
        throw new IllegalStateException("Unable to find sequence with start (" + start + ") and end (" + end + ") in (" + consecutiveData.getConsecutiveSequences() + ")");
    }

    private static AtomicInteger atomic(int value) {
        return new AtomicInteger(value);
    }

    @Test
    void testNonconsecutiveNumbers() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger start1 = ConsecutiveSetTreeTest.atomic(3);
        AtomicInteger middle3 = ConsecutiveSetTreeTest.atomic(5);
        AtomicInteger end7 = ConsecutiveSetTreeTest.atomic(5);
        tree.add((Object)start1, (Comparable)Integer.valueOf(1));
        tree.add((Object)middle3, (Comparable)Integer.valueOf(3));
        tree.add((Object)end7, (Comparable)Integer.valueOf(7));
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(3);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(2);
        Assertions.assertThat((Iterable)tree.getConsecutiveSequences()).allMatch(seq -> seq.getCount() == 1);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)start1, (Object)middle3, 2));
        Assertions.assertThat((Object)((Break)breakList.get(1))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)middle3, (Object)end7, 4));
    }

    @Test
    void testConsecutiveNumbers() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger breakStart3 = ConsecutiveSetTreeTest.atomic(3);
        AtomicInteger breakEnd5 = ConsecutiveSetTreeTest.atomic(5);
        tree.add((Object)ConsecutiveSetTreeTest.atomic(1), (Comparable)Integer.valueOf(1));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(2), (Comparable)Integer.valueOf(2));
        tree.add((Object)breakStart3, (Comparable)Integer.valueOf(3));
        tree.add((Object)breakEnd5, (Comparable)Integer.valueOf(5));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(6), (Comparable)Integer.valueOf(6));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(7), (Comparable)Integer.valueOf(7));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(8), (Comparable)Integer.valueOf(8));
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(2);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((int)((Sequence)sequenceList.get(1)).getCount()).isEqualTo(4);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)breakStart3, (Object)breakEnd5, 2));
    }

    @Test
    void testDuplicateNumbers() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger duplicateValue = ConsecutiveSetTreeTest.atomic(3);
        tree.add((Object)ConsecutiveSetTreeTest.atomic(1), (Comparable)Integer.valueOf(1));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(2), (Comparable)Integer.valueOf(2));
        tree.add((Object)duplicateValue, (Comparable)Integer.valueOf(3));
        tree.add((Object)duplicateValue, (Comparable)Integer.valueOf(3));
        tree.add((Object)duplicateValue, (Comparable)Integer.valueOf(3));
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(0);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
        duplicateValue.set(0);
        tree.remove((Object)duplicateValue);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat(breakList).hasSize(0);
        tree.remove((Object)duplicateValue);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat(breakList).hasSize(0);
        tree.remove((Object)duplicateValue);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(2);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    void testConsecutiveReverseNumbers() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger breakStart3 = ConsecutiveSetTreeTest.atomic(3);
        AtomicInteger breakEnd5 = ConsecutiveSetTreeTest.atomic(5);
        tree.add((Object)breakStart3, (Comparable)Integer.valueOf(3));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(2), (Comparable)Integer.valueOf(2));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(1), (Comparable)Integer.valueOf(1));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(8), (Comparable)Integer.valueOf(8));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(7), (Comparable)Integer.valueOf(7));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(6), (Comparable)Integer.valueOf(6));
        tree.add((Object)breakEnd5, (Comparable)Integer.valueOf(5));
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(2);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((int)((Sequence)sequenceList.get(1)).getCount()).isEqualTo(4);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)breakStart3, (Object)breakEnd5, 2));
    }

    @Test
    void testJoinOfTwoChains() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        tree.add((Object)ConsecutiveSetTreeTest.atomic(1), (Comparable)Integer.valueOf(1));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(2), (Comparable)Integer.valueOf(2));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(3), (Comparable)Integer.valueOf(3));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(5), (Comparable)Integer.valueOf(5));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(6), (Comparable)Integer.valueOf(6));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(7), (Comparable)Integer.valueOf(7));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(8), (Comparable)Integer.valueOf(8));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(4), (Comparable)Integer.valueOf(4));
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(8);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    void testBreakOfChain() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger removed4 = ConsecutiveSetTreeTest.atomic(4);
        AtomicInteger breakStart3 = ConsecutiveSetTreeTest.atomic(3);
        AtomicInteger breakEnd5 = ConsecutiveSetTreeTest.atomic(5);
        tree.add((Object)ConsecutiveSetTreeTest.atomic(1), (Comparable)Integer.valueOf(1));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(2), (Comparable)Integer.valueOf(2));
        tree.add((Object)breakStart3, (Comparable)Integer.valueOf(3));
        tree.add((Object)removed4, (Comparable)Integer.valueOf(4));
        tree.add((Object)breakEnd5, (Comparable)Integer.valueOf(5));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(6), (Comparable)Integer.valueOf(6));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(7), (Comparable)Integer.valueOf(7));
        removed4.set(8);
        tree.remove((Object)removed4);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(2);
        IterableList breakList = new IterableList(tree.getBreaks());
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat(sequenceList).hasSize(2);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((int)((Sequence)sequenceList.get(1)).getCount()).isEqualTo(3);
        Assertions.assertThat(breakList).hasSize(1);
        Assertions.assertThat((Object)((Break)breakList.get(0))).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)breakStart3, (Object)breakEnd5, 2));
    }

    @Test
    void testChainRemoval() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger removed1 = ConsecutiveSetTreeTest.atomic(1);
        AtomicInteger removed2 = ConsecutiveSetTreeTest.atomic(2);
        AtomicInteger removed3 = ConsecutiveSetTreeTest.atomic(3);
        tree.add((Object)removed1, (Comparable)Integer.valueOf(1));
        tree.add((Object)removed2, (Comparable)Integer.valueOf(2));
        tree.add((Object)removed3, (Comparable)Integer.valueOf(3));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(5), (Comparable)Integer.valueOf(5));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(6), (Comparable)Integer.valueOf(6));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(7), (Comparable)Integer.valueOf(7));
        removed1.set(3);
        removed2.set(10);
        removed3.set(-1);
        tree.remove((Object)removed2);
        tree.remove((Object)removed1);
        tree.remove((Object)removed3);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    void testShorteningOfChain() {
        ConsecutiveSetTree<AtomicInteger, Integer, Integer> tree = this.getIntegerConsecutiveSetTree();
        AtomicInteger start = ConsecutiveSetTreeTest.atomic(1);
        AtomicInteger end = ConsecutiveSetTreeTest.atomic(7);
        tree.add((Object)start, (Comparable)Integer.valueOf(1));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(2), (Comparable)Integer.valueOf(2));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(3), (Comparable)Integer.valueOf(3));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(4), (Comparable)Integer.valueOf(4));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(5), (Comparable)Integer.valueOf(5));
        tree.add((Object)ConsecutiveSetTreeTest.atomic(6), (Comparable)Integer.valueOf(6));
        tree.add((Object)end, (Comparable)Integer.valueOf(7));
        end.set(3);
        tree.remove((Object)end);
        IterableList sequenceList = new IterableList(tree.getConsecutiveSequences());
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(6);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
        start.set(3);
        tree.remove((Object)start);
        Assertions.assertThat(sequenceList).hasSize(1);
        Assertions.assertThat((int)((Sequence)sequenceList.get(0)).getCount()).isEqualTo(5);
        Assertions.assertThat((Iterable)tree.getBreaks()).hasSize(0);
    }

    @Test
    void testRandomSequences() {
        Random random = new Random(1L);
        TreeMap<Integer, Integer> valueToCountMap = new TreeMap<Integer, Integer>();
        ConsecutiveSetTree tree = new ConsecutiveSetTree((a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
        for (int i = 0; i < 1000; ++i) {
            String op;
            int value = random.nextInt(64);
            if (valueToCountMap.containsKey(value) && random.nextDouble() < 0.75) {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Removing " + value + " from [", "]"));
                valueToCountMap.computeIfPresent(value, (key, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                tree.remove((Object)value);
            } else {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Adding " + value + " to [", "]"));
                valueToCountMap.merge(value, 1, Integer::sum);
                tree.add((Object)value, (Comparable)Integer.valueOf(value));
            }
            ConsecutiveSetTree freshTree = new ConsecutiveSetTree((a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
            for (Map.Entry entry : valueToCountMap.entrySet()) {
                IntStream.range(0, (Integer)entry.getValue()).map(index -> (Integer)entry.getKey()).forEach(key -> freshTree.add((Object)key, (Comparable)Integer.valueOf(key)));
            }
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveSequences()).as("Mismatched Sequence: " + op, new Object[0])).usingRecursiveComparison().ignoringFields(new String[]{"sourceTree"}).isEqualTo((Object)freshTree.getConsecutiveSequences());
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getBreaks()).as("Mismatched Break: " + op, new Object[0])).usingRecursiveComparison().isEqualTo((Object)freshTree.getBreaks());
        }
    }

    @Test
    void testRandomSequencesWithDuplicates() {
        Random random = new Random(1L);
        TreeMap<Integer, Integer> valueToCountMap = new TreeMap<Integer, Integer>(Comparator.comparing(Math::abs).thenComparing(System::identityHashCode));
        ConsecutiveSetTree tree = new ConsecutiveSetTree((a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
        for (int i = 0; i < 1000; ++i) {
            String op;
            int value = random.nextInt(64) - 32;
            if (valueToCountMap.containsKey(value) && random.nextDouble() < 0.75) {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Removing " + value + " from [", "]"));
                valueToCountMap.computeIfPresent(value, (key, count) -> count == 1 ? null : Integer.valueOf(count - 1));
                tree.remove((Object)value);
            } else {
                op = valueToCountMap.keySet().stream().map(Object::toString).collect(Collectors.joining(", ", "Adding " + value + " to [", "]"));
                valueToCountMap.merge(value, 1, Integer::sum);
                tree.add((Object)value, (Comparable)Integer.valueOf(Math.abs(value)));
            }
            ConsecutiveSetTree freshTree = new ConsecutiveSetTree((a, b) -> b - a, Integer::sum, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(0));
            for (Map.Entry entry : valueToCountMap.entrySet()) {
                IntStream.range(0, (Integer)entry.getValue()).map(index -> (Integer)entry.getKey()).forEach(key -> freshTree.add((Object)key, (Comparable)Integer.valueOf(Math.abs(key))));
            }
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getConsecutiveSequences()).as("Mismatched Sequence: " + op, new Object[0])).usingRecursiveComparison().ignoringFields(new String[]{"sourceTree"}).isEqualTo((Object)freshTree.getConsecutiveSequences());
            ((IterableAssert)Assertions.assertThat((Iterable)tree.getBreaks()).as("Mismatched Break: " + op, new Object[0])).usingRecursiveComparison().isEqualTo((Object)freshTree.getBreaks());
        }
    }

    @Test
    void testTimeslotConsecutive() {
        ConsecutiveSetTree tree = new ConsecutiveSetTree(Duration::between, Duration::plus, (Comparable)Duration.ofDays(1L), (Comparable)Duration.ZERO);
        Timeslot t1 = new Timeslot(0, 1);
        Timeslot t2 = new Timeslot(1, 2);
        Timeslot t3 = new Timeslot(3, 4);
        Timeslot t4 = new Timeslot(4, 5);
        Timeslot t5 = new Timeslot(5, 6);
        tree.add((Object)t4, (Comparable)t4.from);
        tree.add((Object)t2, (Comparable)t2.from);
        tree.add((Object)t4, (Comparable)t4.from);
        tree.add((Object)t3, (Comparable)t3.from);
        tree.add((Object)t1, (Comparable)t1.from);
        tree.add((Object)t5, (Comparable)t5.from);
        Iterable sequenceList = tree.getConsecutiveSequences();
        Assertions.assertThat((Iterable)sequenceList).hasSize(2);
        Iterator sequenceIterator = sequenceList.iterator();
        Iterable breakList = tree.getBreaks();
        Iterator breakIterator = breakList.iterator();
        Assertions.assertThat((Iterable)breakList).hasSize(1);
        Assertions.assertThat((Iterable)sequenceList).hasSize(2);
        Assertions.assertThat((Iterable)((Sequence)sequenceIterator.next()).getItems()).containsExactly((Object[])new Timeslot[]{t1, t2});
        Assertions.assertThat((Iterable)((Sequence)sequenceIterator.next()).getItems()).containsExactly((Object[])new Timeslot[]{t3, t4, t5});
        Assertions.assertThat((Iterable)breakList).hasSize(1);
        Assertions.assertThat((Object)((Break)breakIterator.next())).usingRecursiveComparison().isEqualTo(this.getBreak((ConsecutiveInfo)tree, (Object)t2, (Object)t3, (Comparable)Duration.ofDays(2L)));
    }

    private static class Timeslot {
        OffsetDateTime from;
        OffsetDateTime to;

        public Timeslot(int fromIndex, int toIndex) {
            this.from = OffsetDateTime.of(2000, 1, fromIndex + 1, 0, 0, 0, 0, ZoneOffset.UTC);
            this.to = OffsetDateTime.of(2000, 1, toIndex + 1, 0, 0, 0, 0, ZoneOffset.UTC);
        }
    }
}

