/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.curriculumcourse.domain.Curriculum;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;
import org.optaplanner.examples.curriculumcourse.domain.solver.CourseConflict;

public class CurriculumCourseConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.conflictingLecturesDifferentCourseInSamePeriod(factory), this.conflictingLecturesSameCourseInSamePeriod(factory), this.roomOccupancy(factory), this.unavailablePeriodPenalty(factory), this.roomCapacity(factory), this.minimumWorkingDays(factory), this.curriculumCompactness(factory), this.roomStability(factory)};
    }

    Constraint conflictingLecturesDifferentCourseInSamePeriod(ConstraintFactory factory) {
        return factory.from(CourseConflict.class).join(Lecture.class, Joiners.equal(CourseConflict::getLeftCourse, Lecture::getCourse)).join(Lecture.class, Joiners.equal((courseConflict, lecture1) -> courseConflict.getRightCourse(), Lecture::getCourse), Joiners.equal((courseConflict, lecture1) -> lecture1.getPeriod(), Lecture::getPeriod)).filter((courseConflict, lecture1, lecture2) -> lecture1 != lecture2).penalize("conflictingLecturesDifferentCourseInSamePeriod", (Score)HardSoftScore.ONE_HARD, (courseConflict, lecture1, lecture2) -> courseConflict.getConflictCount());
    }

    Constraint conflictingLecturesSameCourseInSamePeriod(ConstraintFactory factory) {
        return factory.fromUniquePair(Lecture.class, Joiners.equal(Lecture::getPeriod), Joiners.equal(Lecture::getCourse)).penalize("conflictingLecturesSameCourseInSamePeriod", (Score)HardSoftScore.ONE_HARD, (lecture1, lecture2) -> 1 + lecture1.getCurriculumSet().size());
    }

    Constraint roomOccupancy(ConstraintFactory factory) {
        return factory.fromUniquePair(Lecture.class, Joiners.equal(Lecture::getRoom), Joiners.equal(Lecture::getPeriod)).penalize("roomOccupancy", (Score)HardSoftScore.ONE_HARD);
    }

    Constraint unavailablePeriodPenalty(ConstraintFactory factory) {
        return factory.from(UnavailablePeriodPenalty.class).join(Lecture.class, Joiners.equal(UnavailablePeriodPenalty::getCourse, Lecture::getCourse), Joiners.equal(UnavailablePeriodPenalty::getPeriod, Lecture::getPeriod)).penalize("unavailablePeriodPenalty", (Score)HardSoftScore.ofHard((int)10));
    }

    Constraint roomCapacity(ConstraintFactory factory) {
        return factory.from(Lecture.class).filter(lecture -> lecture.getStudentSize() > lecture.getRoom().getCapacity()).penalize("roomCapacity", (Score)HardSoftScore.ofSoft((int)1), lecture -> lecture.getStudentSize() - lecture.getRoom().getCapacity());
    }

    Constraint minimumWorkingDays(ConstraintFactory factory) {
        return factory.from(Lecture.class).groupBy(Lecture::getCourse, ConstraintCollectors.countDistinct(Lecture::getDay)).filter((course, dayCount) -> course.getMinWorkingDaySize() > dayCount).penalize("minimumWorkingDays", (Score)HardSoftScore.ofSoft((int)5), (course, dayCount) -> course.getMinWorkingDaySize() - dayCount);
    }

    Constraint curriculumCompactness(ConstraintFactory factory) {
        return factory.from(Curriculum.class).join(Lecture.class, Joiners.filtering((curriculum, lecture) -> lecture.getCurriculumSet().contains(curriculum))).ifNotExists(Lecture.class, Joiners.equal((curriculum, lecture) -> lecture.getDay(), Lecture::getDay), Joiners.equal((curriculum, lecture) -> lecture.getTimeslotIndex(), lecture -> lecture.getTimeslotIndex() + 1), Joiners.filtering((curriculum, lectureA, lectureB) -> lectureB.getCurriculumSet().contains(curriculum))).ifNotExists(Lecture.class, Joiners.equal((curriculum, lecture) -> lecture.getDay(), Lecture::getDay), Joiners.equal((curriculum, lecture) -> lecture.getTimeslotIndex(), lecture -> lecture.getTimeslotIndex() - 1), Joiners.filtering((curriculum, lectureA, lectureB) -> lectureB.getCurriculumSet().contains(curriculum))).penalize("curriculumCompactness", (Score)HardSoftScore.ofSoft((int)2));
    }

    Constraint roomStability(ConstraintFactory factory) {
        return factory.from(Lecture.class).groupBy(Lecture::getCourse, ConstraintCollectors.countDistinct(Lecture::getRoom)).filter((course, roomCount) -> roomCount > 1).penalize("roomStability", (Score)HardSoftScore.ofSoft((int)1), (course, roomCount) -> roomCount - 1);
    }
}

