/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.domain.solver;

import java.util.Objects;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;
import org.optaplanner.examples.taskassigning.domain.TaskOrEmployee;

public class StartTimeUpdatingVariableListener
implements VariableListener<TaskAssigningSolution, Task> {
    public void beforeEntityAdded(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    public void afterEntityAdded(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
        this.updateStartTime(scoreDirector, task);
    }

    public void beforeVariableChanged(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    public void afterVariableChanged(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
        this.updateStartTime(scoreDirector, task);
    }

    public void beforeEntityRemoved(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    public void afterEntityRemoved(ScoreDirector<TaskAssigningSolution> scoreDirector, Task task) {
    }

    protected void updateStartTime(ScoreDirector<TaskAssigningSolution> scoreDirector, Task sourceTask) {
        Task shadowTask;
        TaskOrEmployee previous = sourceTask.getPreviousTaskOrEmployee();
        Integer previousEndTime = previous == null ? null : previous.getEndTime();
        Integer startTime = this.calculateStartTime(shadowTask, previousEndTime);
        for (shadowTask = sourceTask; shadowTask != null && !Objects.equals(shadowTask.getStartTime(), startTime); shadowTask = shadowTask.getNextTask()) {
            scoreDirector.beforeVariableChanged((Object)shadowTask, "startTime");
            shadowTask.setStartTime(startTime);
            scoreDirector.afterVariableChanged((Object)shadowTask, "startTime");
            previousEndTime = shadowTask.getEndTime();
            startTime = this.calculateStartTime(shadowTask, previousEndTime);
        }
    }

    private Integer calculateStartTime(Task task, Integer previousEndTime) {
        if (task == null || previousEndTime == null) {
            return null;
        }
        return Math.max(task.getReadyTime(), previousEndTime);
    }
}

