/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.common.experimental.impl.IntervalCluster;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTree;

public class IntervalTreeTest {
    private IntervalTree<Interval, Integer> getIntegerIntervalTree() {
        return new IntervalTree(Interval::getStart, Interval::getEnd);
    }

    @Test
    public void testNonConsecutiveIntervals() {
        IntervalTree<Interval, Integer> tree = this.getIntegerIntervalTree();
        tree.add((Object)new Interval(0, 2));
        tree.add((Object)new Interval(3, 4));
        tree.add((Object)new Interval(5, 7));
        Iterable clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(3);
        Iterator iterator = clusterList.iterator();
        IntervalCluster intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{new Interval(0, 2)});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{new Interval(3, 4)});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{new Interval(5, 7)});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
    }

    @Test
    public void testConsecutiveIntervals() {
        IntervalTree<Interval, Integer> tree = this.getIntegerIntervalTree();
        tree.add((Object)new Interval(0, 2));
        tree.add((Object)new Interval(2, 4));
        tree.add((Object)new Interval(4, 7));
        Iterable clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(1);
        Iterator iterator = clusterList.iterator();
        IntervalCluster intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{new Interval(0, 2), new Interval(2, 4), new Interval(4, 7)});
    }

    @Test
    public void testDuplicateIntervals() {
        IntervalTree<Interval, Integer> tree = this.getIntegerIntervalTree();
        Interval a = new Interval(0, 2);
        Interval b = new Interval(4, 7);
        tree.add((Object)a);
        tree.add((Object)a);
        tree.add((Object)b);
        Iterable clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(2);
        Iterator iterator = clusterList.iterator();
        IntervalCluster intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{a, a});
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{b});
    }

    @Test
    public void testIntervalRemoval() {
        IntervalTree<Interval, Integer> tree = this.getIntegerIntervalTree();
        Interval a = new Interval(0, 2);
        Interval b = new Interval(2, 4);
        Interval c = new Interval(4, 7);
        tree.add((Object)a);
        tree.add((Object)b);
        tree.add((Object)c);
        tree.remove((Object)b);
        Iterable clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(2);
        Iterator iterator = clusterList.iterator();
        IntervalCluster intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{new Interval(0, 2)});
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{new Interval(4, 7)});
    }

    @Test
    public void testOverlappingInterval() {
        IntervalTree<Interval, Integer> tree = this.getIntegerIntervalTree();
        Interval a = new Interval(0, 2);
        Interval b = new Interval(1, 3);
        Interval c = new Interval(2, 4);
        Interval d = new Interval(5, 6);
        Interval e = new Interval(7, 9);
        Interval f = new Interval(7, 9);
        tree.add((Object)a);
        tree.add((Object)b);
        tree.add((Object)c);
        tree.add((Object)d);
        tree.add((Object)e);
        tree.add((Object)f);
        Iterable clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(3);
        Iterator iterator = clusterList.iterator();
        IntervalCluster intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{a, b, c});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isTrue();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{d});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{e, f});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isTrue();
        tree.remove((Object)b);
        clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(3);
        iterator = clusterList.iterator();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{a, c});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{d});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{e, f});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isTrue();
        tree.remove((Object)f);
        clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(3);
        iterator = clusterList.iterator();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{a, c});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{d});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{e});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        Interval g = new Interval(6, 7);
        tree.add((Object)g);
        clusterList = tree.getConsecutiveIntervalData().getIntervalClusters();
        Assertions.assertThat((Iterable)clusterList).hasSize(2);
        iterator = clusterList.iterator();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{a, c});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
        intervalCluster = (IntervalCluster)iterator.next();
        Assertions.assertThat((Iterable)intervalCluster).containsExactly((Object[])new Interval[]{d, g, e});
        Assertions.assertThat((boolean)intervalCluster.hasOverlap()).isFalse();
    }

    @Test
    public void testRandomIntervals() {
        Random random = new Random(1L);
        HashMap intervalToInstanceMap = new HashMap();
        TreeSet<IntervalSplitPoint> splitPoints = new TreeSet<IntervalSplitPoint>();
        IntervalTree tree = new IntervalTree(Interval::getStart, Interval::getEnd);
        for (int i = 0; i < 10000; ++i) {
            int from = random.nextInt(50);
            int to = from + random.nextInt(50);
            Interval interval = (Interval)intervalToInstanceMap.computeIfAbsent(new Interval(from, to), Function.identity());
            org.optaplanner.examples.common.experimental.impl.Interval treeInterval = new org.optaplanner.examples.common.experimental.impl.Interval((Object)interval, Interval::getStart, Interval::getEnd);
            splitPoints.add(treeInterval.getStartSplitPoint());
            splitPoints.add(treeInterval.getEndSplitPoint());
            IntervalSplitPoint startSplitPoint = splitPoints.floor(treeInterval.getStartSplitPoint());
            IntervalSplitPoint endSplitPoint = splitPoints.floor(treeInterval.getEndSplitPoint());
            if (startSplitPoint.startIntervalToCountMap == null) {
                startSplitPoint.createCollections();
            }
            if (endSplitPoint.endIntervalToCountMap == null) {
                endSplitPoint.createCollections();
            }
            if (startSplitPoint.containsIntervalStarting(treeInterval) && random.nextBoolean()) {
                startSplitPoint.removeIntervalStartingAtSplitPoint(treeInterval);
                endSplitPoint.removeIntervalEndingAtSplitPoint(treeInterval);
                if (startSplitPoint.isEmpty()) {
                    splitPoints.remove(startSplitPoint);
                }
                if (endSplitPoint.isEmpty()) {
                    splitPoints.remove(endSplitPoint);
                }
                tree.remove((Object)interval);
            } else {
                startSplitPoint.addIntervalStartingAtSplitPoint(treeInterval);
                endSplitPoint.addIntervalEndingAtSplitPoint(treeInterval);
                tree.add((Object)interval);
            }
            IntervalSplitPoint current = (IntervalSplitPoint)splitPoints.first();
            ArrayList<IntervalCluster> intervalClusterList = new ArrayList<IntervalCluster>();
            while (current != null) {
                intervalClusterList.add(new IntervalCluster(splitPoints, current));
                current = splitPoints.higher(((IntervalCluster)intervalClusterList.get(intervalClusterList.size() - 1)).getEndSplitPoint());
            }
            Assertions.assertThat((Iterable)tree.getConsecutiveIntervalData().getIntervalClusters()).containsExactlyElementsOf(intervalClusterList);
        }
    }

    private static class Interval {
        final int start;
        final int end;

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            return this.start == interval.start && this.end == interval.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

