/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.optional.score;

import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.optional.score.VehicleRoutingConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

public class VehicleRoutingConstraintProviderTest {
    private final ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new VehicleRoutingConstraintProvider(), VehicleRoutingSolution.class, (Class[])new Class[]{Standstill.class, Customer.class, TimeWindowedCustomer.class});
    private final Location location1 = new AirLocation(1L, 0.0, 0.0);
    private final Location location2 = new AirLocation(2L, 0.0, 4.0);
    private final Location location3 = new AirLocation(3L, 3.0, 0.0);

    @Test
    public void vehicleCapacityUnpenalized() {
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        Customer customer1 = new Customer(2L, this.location2, 80);
        customer1.setPreviousStandstill((Standstill)vehicleA);
        customer1.setVehicle(vehicleA);
        vehicleA.setNextCustomer(customer1);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{vehicleA, customer1}).penalizesBy(0);
    }

    @Test
    public void vehicleCapacityPenalized() {
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        Customer customer1 = new Customer(2L, this.location2, 80);
        customer1.setPreviousStandstill((Standstill)vehicleA);
        customer1.setVehicle(vehicleA);
        vehicleA.setNextCustomer(customer1);
        Customer customer2 = new Customer(3L, this.location3, 40);
        customer2.setPreviousStandstill((Standstill)customer1);
        customer2.setVehicle(vehicleA);
        customer1.setNextCustomer(customer2);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(20);
    }

    @Test
    public void distanceToPreviousStandstill() {
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        Customer customer1 = new Customer(2L, this.location2, 80);
        customer1.setPreviousStandstill((Standstill)vehicleA);
        customer1.setVehicle(vehicleA);
        vehicleA.setNextCustomer(customer1);
        Customer customer2 = new Customer(3L, this.location3, 40);
        customer2.setPreviousStandstill((Standstill)customer1);
        customer2.setVehicle(vehicleA);
        customer1.setNextCustomer(customer2);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceToPreviousStandstill).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(9000L);
    }

    @Test
    public void distanceFromLastCustomerToDepot() {
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        Customer customer1 = new Customer(2L, this.location2, 80);
        customer1.setPreviousStandstill((Standstill)vehicleA);
        customer1.setVehicle(vehicleA);
        vehicleA.setNextCustomer(customer1);
        Customer customer2 = new Customer(3L, this.location3, 40);
        customer2.setPreviousStandstill((Standstill)customer1);
        customer2.setVehicle(vehicleA);
        customer1.setNextCustomer(customer2);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromLastCustomerToDepot).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(3000L);
    }

    @Test
    public void arrivalAfterDueTime() {
        Vehicle vehicleA = new Vehicle(1L, 100, (Depot)new TimeWindowedDepot(1L, this.location1, 80000L, 180000L));
        TimeWindowedCustomer customer1 = new TimeWindowedCustomer(2L, this.location2, 1, 80000L, 180000L, 10000L);
        customer1.setPreviousStandstill((Standstill)vehicleA);
        customer1.setVehicle(vehicleA);
        vehicleA.setNextCustomer((Customer)customer1);
        customer1.setArrivalTime(Long.valueOf(84000L));
        TimeWindowedCustomer customer2 = new TimeWindowedCustomer(3L, this.location3, 40, 80000L, 90000L, 10000L);
        customer2.setPreviousStandstill((Standstill)customer1);
        customer2.setVehicle(vehicleA);
        customer1.setNextCustomer((Customer)customer2);
        customer2.setArrivalTime(Long.valueOf(99000L));
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::arrivalAfterDueTime).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(9000L);
    }
}

