/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import org.optaplanner.examples.common.experimental.impl.Interval;
import org.optaplanner.examples.common.experimental.impl.IntervalSplitPoint;
import org.optaplanner.examples.common.experimental.impl.IntervalTreeIterator;

public class IntervalCluster<IntervalValue_, PointValue_ extends Comparable<PointValue_>>
implements Iterable<IntervalValue_> {
    IntervalSplitPoint<IntervalValue_, PointValue_> startSplitPoint;
    IntervalSplitPoint<IntervalValue_, PointValue_> endSplitPoint;
    int count;
    boolean hasOverlap;
    final NavigableSet<IntervalSplitPoint<IntervalValue_, PointValue_>> splitPointSet;

    public IntervalCluster(NavigableSet<IntervalSplitPoint<IntervalValue_, PointValue_>> splitPointSet, IntervalSplitPoint<IntervalValue_, PointValue_> start) {
        if (start == null) {
            throw new IllegalArgumentException("start (" + start + ") is null");
        }
        this.splitPointSet = splitPointSet;
        this.startSplitPoint = start;
        int activeIntervals = 0;
        this.count = 0;
        boolean anyOverlap = false;
        IntervalSplitPoint<IntervalValue_, PointValue_> current = start;
        do {
            this.count += current.intervalsStartingAtSplitPointSet.size();
            if ((activeIntervals += current.intervalsStartingAtSplitPointSet.size() - current.intervalsEndingAtSplitPointSet.size()) > 1) {
                anyOverlap = true;
            }
            current = splitPointSet.higher(current);
        } while (activeIntervals > 0 && current != null);
        this.hasOverlap = anyOverlap;
        this.endSplitPoint = current != null ? splitPointSet.lower(current) : (IntervalSplitPoint)splitPointSet.last();
    }

    public IntervalCluster(NavigableSet<IntervalSplitPoint<IntervalValue_, PointValue_>> splitPointSet, IntervalSplitPoint<IntervalValue_, PointValue_> start, IntervalSplitPoint<IntervalValue_, PointValue_> end, int count, boolean hasOverlap) {
        this.splitPointSet = splitPointSet;
        this.startSplitPoint = start;
        this.endSplitPoint = end;
        this.count = count;
        this.hasOverlap = hasOverlap;
    }

    public IntervalSplitPoint<IntervalValue_, PointValue_> getStartSplitPoint() {
        return this.startSplitPoint;
    }

    public IntervalSplitPoint<IntervalValue_, PointValue_> getEndSplitPoint() {
        return this.endSplitPoint;
    }

    public void addInterval(Interval<IntervalValue_, PointValue_> interval) {
        if (interval.getEndSplitPoint().compareTo(this.getStartSplitPoint()) > 0 && interval.getStartSplitPoint().compareTo(this.getEndSplitPoint()) < 0) {
            this.hasOverlap = true;
        }
        if (interval.getStartSplitPoint().compareTo(this.startSplitPoint) < 0) {
            this.startSplitPoint = this.splitPointSet.floor(interval.getStartSplitPoint());
        }
        if (interval.getEndSplitPoint().compareTo(this.endSplitPoint) > 0) {
            this.endSplitPoint = this.splitPointSet.ceiling(interval.getEndSplitPoint());
        }
        ++this.count;
    }

    public Iterable<IntervalCluster<IntervalValue_, PointValue_>> removeInterval(Interval<IntervalValue_, PointValue_> interval) {
        return () -> new Iterator<IntervalCluster<IntervalValue_, PointValue_>>(){
            IntervalSplitPoint current;
            {
                this.current = IntervalCluster.this.startSplitPoint;
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.compareTo(IntervalCluster.this.endSplitPoint) < 0 && !IntervalCluster.this.splitPointSet.isEmpty();
            }

            @Override
            public IntervalCluster<IntervalValue_, PointValue_> next() {
                IntervalSplitPoint start = this.current;
                int activeIntervals = 0;
                IntervalCluster.this.count = 0;
                boolean anyOverlap = false;
                do {
                    IntervalCluster.this.count += this.current.intervalsStartingAtSplitPointSet.size();
                    if ((activeIntervals += this.current.intervalsStartingAtSplitPointSet.size() - this.current.intervalsEndingAtSplitPointSet.size()) > 1) {
                        anyOverlap = true;
                    }
                    this.current = IntervalCluster.this.splitPointSet.higher(this.current);
                } while (activeIntervals > 0 && this.current != null);
                IntervalCluster.this.hasOverlap = anyOverlap;
                IntervalSplitPoint end = this.current != null ? IntervalCluster.this.splitPointSet.lower(this.current) : (IntervalSplitPoint)IntervalCluster.this.splitPointSet.last();
                return new IntervalCluster(IntervalCluster.this.splitPointSet, start, end, IntervalCluster.this.count, IntervalCluster.this.hasOverlap);
            }
        };
    }

    public void mergeIntervalCluster(IntervalCluster<IntervalValue_, PointValue_> laterIntervalCluster) {
        this.count += laterIntervalCluster.count;
        this.endSplitPoint = laterIntervalCluster.endSplitPoint;
        this.hasOverlap |= laterIntervalCluster.hasOverlap;
    }

    @Override
    public Iterator<IntervalValue_> iterator() {
        return new IntervalTreeIterator<IntervalValue_, PointValue_>(this.splitPointSet.subSet(this.startSplitPoint, true, this.endSplitPoint, true));
    }

    public int size() {
        return this.count;
    }

    public boolean hasOverlap() {
        return this.hasOverlap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalCluster that = (IntervalCluster)o;
        return this.startSplitPoint.equals(that.startSplitPoint) && this.endSplitPoint.equals(that.endSplitPoint);
    }

    public int hashCode() {
        return Objects.hash(this.startSplitPoint, this.endSplitPoint);
    }

    public String toString() {
        return "IntervalCluster{startSplitPoint=" + this.startSplitPoint + ", endSplitPoint=" + this.endSplitPoint + ", count=" + this.count + ", hasOverlap=" + this.hasOverlap + '}';
    }
}

