/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.experimental.impl;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.optaplanner.examples.common.experimental.impl.Interval;

public class IntervalSplitPoint<IntervalValue_, PointValue_ extends Comparable<PointValue_>>
implements Comparable<IntervalSplitPoint<IntervalValue_, PointValue_>> {
    final PointValue_ splitPoint;
    Map<IntervalValue_, Integer> startIntervalToCountMap;
    Map<IntervalValue_, Integer> endIntervalToCountMap;
    TreeSet<Interval<IntervalValue_, PointValue_>> intervalsStartingAtSplitPointSet;
    TreeSet<Interval<IntervalValue_, PointValue_>> intervalsEndingAtSplitPointSet;

    public IntervalSplitPoint(PointValue_ splitPoint) {
        this.splitPoint = splitPoint;
    }

    protected void createCollections() {
        this.startIntervalToCountMap = new IdentityHashMap<IntervalValue_, Integer>();
        this.endIntervalToCountMap = new IdentityHashMap<IntervalValue_, Integer>();
        this.intervalsStartingAtSplitPointSet = new TreeSet<Interval>(Comparator.comparing(Interval::getEnd).thenComparingInt(interval -> System.identityHashCode(interval.value)));
        this.intervalsEndingAtSplitPointSet = new TreeSet<Interval>(Comparator.comparing(Interval::getStart).thenComparingInt(interval -> System.identityHashCode(interval.value)));
    }

    public boolean addIntervalStartingAtSplitPoint(Interval<IntervalValue_, PointValue_> interval) {
        this.startIntervalToCountMap.merge(interval.value, 1, Integer::sum);
        return this.intervalsStartingAtSplitPointSet.add(interval);
    }

    public void removeIntervalStartingAtSplitPoint(Interval<IntervalValue_, PointValue_> interval) {
        Integer newCount = this.startIntervalToCountMap.computeIfPresent(interval.value, (key, count) -> {
            if (count > 1) {
                return count - 1;
            }
            return null;
        });
        if (null == newCount) {
            this.intervalsStartingAtSplitPointSet.remove(interval);
        }
    }

    public boolean addIntervalEndingAtSplitPoint(Interval<IntervalValue_, PointValue_> interval) {
        this.endIntervalToCountMap.merge(interval.value, 1, Integer::sum);
        return this.intervalsEndingAtSplitPointSet.add(interval);
    }

    public void removeIntervalEndingAtSplitPoint(Interval<IntervalValue_, PointValue_> interval) {
        Integer newCount = this.endIntervalToCountMap.computeIfPresent(interval.value, (key, count) -> {
            if (count > 1) {
                return count - 1;
            }
            return null;
        });
        if (null == newCount) {
            this.intervalsEndingAtSplitPointSet.remove(interval);
        }
    }

    public boolean containsIntervalStarting(Interval<IntervalValue_, PointValue_> interval) {
        return this.intervalsStartingAtSplitPointSet.contains(interval);
    }

    public boolean containsIntervalEnding(Interval<IntervalValue_, PointValue_> interval) {
        return this.intervalsEndingAtSplitPointSet.contains(interval);
    }

    public Iterator<IntervalValue_> getValuesStartingFromSplitPointIterator() {
        return this.intervalsStartingAtSplitPointSet.stream().flatMap(interval -> IntStream.range(0, this.startIntervalToCountMap.get(interval.value)).mapToObj(index -> interval.value)).iterator();
    }

    public boolean isEmpty() {
        return this.intervalsStartingAtSplitPointSet.isEmpty() && this.intervalsEndingAtSplitPointSet.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSplitPoint that = (IntervalSplitPoint)o;
        return this.splitPoint.equals(that.splitPoint);
    }

    public int hashCode() {
        return Objects.hash(this.splitPoint);
    }

    @Override
    public int compareTo(IntervalSplitPoint<IntervalValue_, PointValue_> other) {
        return this.splitPoint.compareTo(other.splitPoint);
    }

    public String toString() {
        return "IntervalSplitPoint{splitPoint=" + this.splitPoint + ", intervalsStartingAtSplitPointSet=" + this.intervalsStartingAtSplitPointSet + ", intervalsEndingAtSplitPointSet=" + this.intervalsEndingAtSplitPointSet + '}';
    }
}

