/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.optional.score;

import java.time.DayOfWeek;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.common.experimental.ExperimentalConstraintCollectors;
import org.optaplanner.examples.common.experimental.api.ConsecutiveInfo;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRosterParametrization;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.ShiftTypeSkillRequirement;
import org.optaplanner.examples.nurserostering.domain.SkillProficiency;
import org.optaplanner.examples.nurserostering.domain.contract.BooleanContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.ContractLineType;
import org.optaplanner.examples.nurserostering.domain.contract.MinMaxContractLine;
import org.optaplanner.examples.nurserostering.domain.contract.PatternContractLine;
import org.optaplanner.examples.nurserostering.domain.pattern.FreeBefore2DaysWithAWorkDayPattern;
import org.optaplanner.examples.nurserostering.domain.pattern.ShiftType2DaysPattern;
import org.optaplanner.examples.nurserostering.domain.pattern.ShiftType3DaysPattern;
import org.optaplanner.examples.nurserostering.domain.request.DayOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.DayOnRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOffRequest;
import org.optaplanner.examples.nurserostering.domain.request.ShiftOnRequest;
import org.optaplanner.examples.nurserostering.score.drools.EmployeeConsecutiveAssignmentEnd;
import org.optaplanner.examples.nurserostering.score.drools.EmployeeConsecutiveAssignmentStart;

public class NurseRosteringConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.oneShiftPerDay(constraintFactory), this.minimumAndMaximumNumberOfAssignments(constraintFactory), this.minimumNumberOfAssignmentsNoAssignments(constraintFactory), this.consecutiveWorkingDays(constraintFactory), this.consecutiveFreeDays(constraintFactory), this.maximumConsecutiveFreeDaysNoAssignments(constraintFactory), this.consecutiveFreeDaysFirstBreak(constraintFactory), this.consecutiveFreeDaysFinalBreak(constraintFactory), this.consecutiveWorkingWeekends(constraintFactory), this.startOnNotFirstDayOfWeekend(constraintFactory), this.endOnNotLastDayOfWeekend(constraintFactory), this.identicalShiftTypesDuringWeekend(constraintFactory), this.dayOffRequest(constraintFactory), this.dayOnRequest(constraintFactory), this.shiftOffRequest(constraintFactory), this.shiftOnRequest(constraintFactory), this.alternativeSkill(constraintFactory), this.unwantedPatternFreeBefore2DaysWithAWorkDayPattern(constraintFactory), this.unwantedPatternShiftType2DaysPattern(constraintFactory), this.unwantedPatternShiftType3DaysPattern(constraintFactory)};
    }

    Constraint oneShiftPerDay(ConstraintFactory constraintFactory) {
        return constraintFactory.fromUniquePair(ShiftAssignment.class, Joiners.equal(ShiftAssignment::getEmployee), Joiners.equal(ShiftAssignment::getShiftDate)).penalize("oneShiftPerDay", (Score)HardSoftScore.ONE_HARD);
    }

    Constraint minimumAndMaximumNumberOfAssignments(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.TOTAL_ASSIGNMENTS && minMaxContractLine.isEnabled()).join(constraintFactory.from(ShiftAssignment.class).filter(shift -> shift.getEmployee() != null), Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((line, shift) -> shift.getEmployee(), (line, shift) -> line, ConstraintCollectors.countBi()).filter((employee, contract, shiftCount) -> contract.isViolated((int)shiftCount)).penalize("Minimum and maximum number of assignments", (Score)HardSoftScore.ONE_SOFT, (employee, contract, shiftCount) -> contract.getViolationAmount((int)shiftCount));
    }

    Constraint minimumNumberOfAssignmentsNoAssignments(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.TOTAL_ASSIGNMENTS && minMaxContractLine.isEnabled()).join(Employee.class, Joiners.equal(ContractLine::getContract, Employee::getContract)).ifNotExists(ShiftAssignment.class, Joiners.equal((contractLine, employee) -> employee, ShiftAssignment::getEmployee)).filter((contract, employee) -> contract.isViolated(0)).penalize("Minimum and maximum number of assignments (no assignments)", (Score)HardSoftScore.ONE_SOFT, (contract, employee) -> contract.getViolationAmount(0));
    }

    Constraint consecutiveWorkingDays(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.CONSECUTIVE_WORKING_DAYS && minMaxContractLine.isEnabled()).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shift) -> shift.getEmployee(), (contract, shift) -> contract, ExperimentalConstraintCollectors.consecutive((contract, shift) -> shift.getShiftDate(), ShiftDate::getDayIndex)).flattenLast(ConsecutiveInfo::getConsecutiveSequences).filter((employee, contract, shiftList) -> contract.isViolated((Integer)shiftList.getLength())).penalize("consecutiveWorkingDays", (Score)HardSoftScore.ONE_SOFT, (employee, contract, shiftList) -> contract.getViolationAmount((Integer)shiftList.getLength()));
    }

    Constraint consecutiveFreeDays(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.CONSECUTIVE_FREE_DAYS && minMaxContractLine.isEnabled()).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shift) -> shift.getEmployee(), (contract, shift) -> contract, ExperimentalConstraintCollectors.consecutive((contract, shift) -> shift.getShiftDate(), ShiftDate::getDayIndex)).flattenLast(ConsecutiveInfo::getBreaks).filter((employee, contract, breakInfo) -> contract.isViolated((Integer)breakInfo.getLength() - 1)).penalize("consecutiveFreeDays", (Score)HardSoftScore.ONE_SOFT, (employee, contract, breakInfo) -> contract.getViolationAmount((Integer)breakInfo.getLength() - 1));
    }

    Constraint maximumConsecutiveFreeDaysNoAssignments(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.CONSECUTIVE_FREE_DAYS && minMaxContractLine.isMaximumEnabled()).join(Employee.class, Joiners.equal(ContractLine::getContract, Employee::getContract)).ifNotExists(ShiftAssignment.class, Joiners.equal((contract, employee) -> employee, ShiftAssignment::getEmployee)).join(NurseRosterParametrization.class, Joiners.lessThan((contract, employee) -> contract.getMaximumValue(), nrp -> nrp.getLastShiftDateDayIndex() - nrp.getFirstShiftDateDayIndex() + 1)).penalize("maximumConsecutiveFreeDays (no shifts)", (Score)HardSoftScore.ONE_SOFT, (contract, employee, nrp) -> contract.getViolationAmount(nrp.getLastShiftDateDayIndex() - nrp.getFirstShiftDateDayIndex() + 1));
    }

    Constraint consecutiveFreeDaysFirstBreak(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.CONSECUTIVE_FREE_DAYS && minMaxContractLine.isEnabled()).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shiftAssignment) -> contract, (contract, shiftAssignment) -> shiftAssignment.getEmployee(), ConstraintCollectors.min((contract, shiftAssignment) -> shiftAssignment)).join(NurseRosterParametrization.class).filter((contract, employee, shiftAssignment, nrp) -> nrp.getFirstShiftDate() != shiftAssignment.getShiftDate() && contract.isViolated(shiftAssignment.getShiftDateDayIndex() - nrp.getFirstShiftDateDayIndex())).penalize("consecutiveFreeDays (first break)", (Score)HardSoftScore.ONE_SOFT, (contractLine, employee, shiftAssignment, nrp) -> contractLine.getViolationAmount(shiftAssignment.getShiftDateDayIndex() - nrp.getFirstShiftDateDayIndex()));
    }

    Constraint consecutiveFreeDaysFinalBreak(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.CONSECUTIVE_FREE_DAYS && minMaxContractLine.isEnabled()).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shiftAssignment) -> contract, (contract, shiftAssignment) -> shiftAssignment.getEmployee(), ConstraintCollectors.max((contract, shiftAssignment) -> shiftAssignment)).join(NurseRosterParametrization.class).filter((contractLine, employee, shiftAssignment, nrp) -> nrp.getLastShiftDate() != shiftAssignment.getShiftDate() && contractLine.isViolated(nrp.getLastShiftDateDayIndex() - shiftAssignment.getShiftDateDayIndex())).penalize("consecutiveFreeDays (final break)", (Score)HardSoftScore.ONE_SOFT, (contractLine, employee, shiftAssignment, nrp) -> contractLine.getViolationAmount(nrp.getLastShiftDateDayIndex() - shiftAssignment.getShiftDateDayIndex()));
    }

    Constraint consecutiveWorkingWeekends(ConstraintFactory constraintFactory) {
        return constraintFactory.from(MinMaxContractLine.class).filter(minMaxContractLine -> minMaxContractLine.getContractLineType() == ContractLineType.CONSECUTIVE_WORKING_WEEKENDS && minMaxContractLine.isEnabled()).join(constraintFactory.from(ShiftAssignment.class).filter(ShiftAssignment::isWeekend), Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shift) -> shift.getEmployee(), (contract, shift) -> contract, ExperimentalConstraintCollectors.consecutive((contract, shift) -> shift.getShiftDate(), shiftDate -> shiftDate.getWeekendSundayIndex() / 7)).flattenLast(ConsecutiveInfo::getConsecutiveSequences).filter((employee, contract, shiftList) -> contract.isViolated((Integer)shiftList.getLength())).penalize("consecutiveWorkingWeekends", (Score)HardSoftScore.ONE_SOFT, (employee, contract, shiftList) -> contract.getViolationAmount((Integer)shiftList.getLength()));
    }

    Constraint startOnNotFirstDayOfWeekend(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BooleanContractLine.class).filter(booleanContractLine -> booleanContractLine.getContractLineType() == ContractLineType.COMPLETE_WEEKENDS && booleanContractLine.isEnabled()).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shift) -> shift.getEmployee(), (contract, shift) -> contract, ExperimentalConstraintCollectors.consecutive((contract, shift) -> shift.getShiftDate(), ShiftDate::getDayIndex)).flattenLast(ConsecutiveInfo::getConsecutiveSequences).filter((employee, contract, shiftList) -> EmployeeConsecutiveAssignmentStart.isWeekendAndNotFirstDayOfWeekend(employee, (ShiftDate)shiftList.getFirstItem())).penalize("startOnNotFirstDayOfWeekend", (Score)HardSoftScore.ONE_SOFT, (employee, contract, shiftList) -> EmployeeConsecutiveAssignmentStart.getDistanceToFirstDayOfWeekend(employee, (ShiftDate)shiftList.getFirstItem()) * contract.getWeight());
    }

    Constraint endOnNotLastDayOfWeekend(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BooleanContractLine.class).filter(booleanContractLine -> booleanContractLine.getContractLineType() == ContractLineType.COMPLETE_WEEKENDS && booleanContractLine.isEnabled()).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).groupBy((contract, shift) -> shift.getEmployee(), (contract, shift) -> contract, ExperimentalConstraintCollectors.consecutive((contract, shift) -> shift.getShiftDate(), ShiftDate::getDayIndex)).flattenLast(ConsecutiveInfo::getConsecutiveSequences).filter((employee, contract, shiftList) -> EmployeeConsecutiveAssignmentEnd.isWeekendAndNotLastDayOfWeekend(employee, (ShiftDate)shiftList.getLastItem())).penalize("endOnNotLastDayOfWeekend", (Score)HardSoftScore.ONE_SOFT, (employee, contract, shiftList) -> EmployeeConsecutiveAssignmentEnd.getDistanceToLastDayOfWeekend(employee, (ShiftDate)shiftList.getLastItem()) * contract.getWeight());
    }

    Constraint identicalShiftTypesDuringWeekend(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BooleanContractLine.class).filter(booleanContractLine -> booleanContractLine.getContractLineType() == ContractLineType.IDENTICAL_SHIFT_TYPES_DURING_WEEKEND && booleanContractLine.isEnabled()).join(constraintFactory.from(ShiftDate.class).filter(date -> date.getDayOfWeek() == DayOfWeek.SUNDAY)).join(constraintFactory.from(ShiftAssignment.class).filter(ShiftAssignment::isWeekend), Joiners.equal((contract, date) -> date.getWeekendSundayIndex(), ShiftAssignment::getWeekendSundayIndex), Joiners.equal((contract, date) -> contract.getContract(), ShiftAssignment::getContract)).groupBy((contract, date, sa) -> contract, (contract, date, sa) -> sa.getEmployee(), (contract, date, sa) -> ImmutablePair.of((Object)sa.getShiftType(), (Object)date), ConstraintCollectors.countTri()).filter((contract, employee, type, count) -> count < employee.getWeekendLength()).penalize("identicalShiftTypesDuringWeekend", (Score)HardSoftScore.ONE_SOFT, (contract, employee, type, count) -> (employee.getWeekendLength() - count) * contract.getWeight());
    }

    Constraint dayOffRequest(ConstraintFactory constraintFactory) {
        return constraintFactory.from(DayOffRequest.class).join(ShiftAssignment.class, Joiners.equal(DayOffRequest::getEmployee, ShiftAssignment::getEmployee), Joiners.equal(DayOffRequest::getShiftDate, ShiftAssignment::getShiftDate)).penalize("dayOffRequest", (Score)HardSoftScore.ONE_SOFT, (dayOffRequest, shiftAssignment) -> dayOffRequest.getWeight());
    }

    Constraint dayOnRequest(ConstraintFactory constraintFactory) {
        return constraintFactory.from(DayOnRequest.class).ifNotExists(ShiftAssignment.class, Joiners.equal(DayOnRequest::getEmployee, ShiftAssignment::getEmployee), Joiners.equal(DayOnRequest::getShiftDate, ShiftAssignment::getShiftDate)).penalize("dayOnRequest", (Score)HardSoftScore.ONE_SOFT, DayOnRequest::getWeight);
    }

    Constraint shiftOffRequest(ConstraintFactory constraintFactory) {
        return constraintFactory.from(ShiftOffRequest.class).join(ShiftAssignment.class, Joiners.equal(ShiftOffRequest::getEmployee, ShiftAssignment::getEmployee), Joiners.equal(ShiftOffRequest::getShift, ShiftAssignment::getShift)).penalize("shiftOffRequest", (Score)HardSoftScore.ONE_SOFT, (shiftOffRequest, shiftAssignment) -> shiftOffRequest.getWeight());
    }

    Constraint shiftOnRequest(ConstraintFactory constraintFactory) {
        return constraintFactory.from(ShiftOnRequest.class).ifNotExists(ShiftAssignment.class, Joiners.equal(ShiftOnRequest::getEmployee, ShiftAssignment::getEmployee), Joiners.equal(ShiftOnRequest::getShift, ShiftAssignment::getShift)).penalize("shiftOnRequest", (Score)HardSoftScore.ONE_SOFT, ShiftOnRequest::getWeight);
    }

    Constraint alternativeSkill(ConstraintFactory constraintFactory) {
        return constraintFactory.from(BooleanContractLine.class).filter(booleanContractLine -> booleanContractLine.getContractLineType().equals((Object)ContractLineType.ALTERNATIVE_SKILL_CATEGORY)).join(ShiftAssignment.class, Joiners.equal(ContractLine::getContract, ShiftAssignment::getContract)).join(ShiftTypeSkillRequirement.class, Joiners.equal((contract, shiftAssignment) -> shiftAssignment.getShiftType(), ShiftTypeSkillRequirement::getShiftType)).ifNotExists(SkillProficiency.class, Joiners.equal((contract, shiftAssignment, skillRequirement) -> shiftAssignment.getEmployee(), SkillProficiency::getEmployee), Joiners.equal((contract, shiftAssignment, skillRequirement) -> skillRequirement.getSkill(), SkillProficiency::getSkill)).penalize("alternativeSkill", (Score)HardSoftScore.ONE_SOFT, (contractLine, shiftAssignment, skillRequirement) -> contractLine.getWeight());
    }

    Constraint unwantedPatternFreeBefore2DaysWithAWorkDayPattern(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PatternContractLine.class).filter(patternContractLine -> patternContractLine.getPattern() instanceof FreeBefore2DaysWithAWorkDayPattern).join(ShiftDate.class, Joiners.equal(contract -> ((FreeBefore2DaysWithAWorkDayPattern)contract.getPattern()).getFreeDayOfWeek(), ShiftDate::getDayOfWeek)).join(Employee.class, Joiners.equal((contractLine, date) -> contractLine.getContract(), Employee::getContract)).ifNotExists(ShiftAssignment.class, Joiners.equal((contractLine, date, employee) -> employee, ShiftAssignment::getEmployee), Joiners.equal((contractLine, date, employee) -> date.getDayIndex(), ShiftAssignment::getShiftDateDayIndex)).ifExists(ShiftAssignment.class, Joiners.equal((contractLine, date, employee) -> employee, ShiftAssignment::getEmployee), Joiners.lessThanOrEqual((contractLine, date, employee) -> date.getDayIndex() + 1, ShiftAssignment::getShiftDateDayIndex), Joiners.greaterThanOrEqual((contractLine, date, employee) -> date.getDayIndex() + 2, ShiftAssignment::getShiftDateDayIndex)).penalize("unwantedPatternFreeBefore2DaysWithAWorkDayPattern", (Score)HardSoftScore.ONE_SOFT, (contractLine, date, employee) -> contractLine.getPattern().getWeight());
    }

    Constraint unwantedPatternShiftType2DaysPattern(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PatternContractLine.class).filter(patternContractLine -> patternContractLine.getPattern() instanceof ShiftType2DaysPattern).join(ShiftAssignment.class, Joiners.equal(contractLine -> ((ShiftType2DaysPattern)contractLine.getPattern()).getDayIndex0ShiftType(), ShiftAssignment::getShiftType), Joiners.equal(PatternContractLine::getContract, ShiftAssignment::getContract)).join(ShiftAssignment.class, Joiners.equal((contractLine, shift) -> shift.getEmployee(), ShiftAssignment::getEmployee), Joiners.equal((contractLine, shift) -> shift.getShiftDateDayIndex() + 1, ShiftAssignment::getShiftDateDayIndex), Joiners.filtering((contractLine, shift1, shift2) -> {
            ShiftType2DaysPattern pattern = (ShiftType2DaysPattern)contractLine.getPattern();
            return pattern.getDayIndex1ShiftType() == null || shift2.getShiftType() == pattern.getDayIndex1ShiftType();
        })).penalize("unwantedPatternShiftType2DaysPattern", (Score)HardSoftScore.ONE_SOFT, (contractLine, shift1, shift2) -> contractLine.getPattern().getWeight());
    }

    Constraint unwantedPatternShiftType3DaysPattern(ConstraintFactory constraintFactory) {
        return constraintFactory.from(PatternContractLine.class).filter(patternContractLine -> patternContractLine.getPattern() instanceof ShiftType3DaysPattern).join(ShiftAssignment.class, Joiners.equal(contractLine -> ((ShiftType3DaysPattern)contractLine.getPattern()).getDayIndex0ShiftType(), ShiftAssignment::getShiftType), Joiners.equal(PatternContractLine::getContract, ShiftAssignment::getContract)).join(ShiftAssignment.class, Joiners.equal((contractLine, shift) -> shift.getEmployee(), ShiftAssignment::getEmployee), Joiners.equal((contractLine, shift) -> shift.getShiftDateDayIndex() + 1, ShiftAssignment::getShiftDateDayIndex), Joiners.equal((contractLine, shift) -> ((ShiftType3DaysPattern)contractLine.getPattern()).getDayIndex1ShiftType(), ShiftAssignment::getShiftType)).join(ShiftAssignment.class, Joiners.equal((contractLine, shift1, shift2) -> shift1.getEmployee(), ShiftAssignment::getEmployee), Joiners.equal((contractLine, shift1, shift2) -> shift1.getShiftDateDayIndex() + 2, ShiftAssignment::getShiftDateDayIndex), Joiners.equal((contractLine, shift1, shift2) -> ((ShiftType3DaysPattern)contractLine.getPattern()).getDayIndex2ShiftType(), ShiftAssignment::getShiftType)).penalize("unwantedPatternShiftType3DaysPattern", (Score)HardSoftScore.ONE_SOFT, (contractLine, shift1, shift2, shift3) -> contractLine.getPattern().getWeight());
    }
}

