/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.app;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.SolveAllTurtleTest;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class ImportDirSolveAllTurtleTest<Solution_>
extends SolveAllTurtleTest<Solution_> {
    private static <Solution_> List<File> getImportDirFiles(CommonApp<Solution_> commonApp) {
        try (SolutionBusiness solutionBusiness = commonApp.solutionBusiness;){
            File importDataDir = solutionBusiness.getImportDataDir();
            if (!importDataDir.exists()) {
                throw new IllegalStateException("The directory importDataDir (" + importDataDir.getAbsolutePath() + ") does not exist.");
            }
            List<File> list = ImportDirSolveAllTurtleTest.getAllFilesRecursivelyAndSorted(importDataDir, arg_0 -> ImportDirSolveAllTurtleTest.createSolutionImporter(commonApp).acceptInputFile(arg_0));
            return list;
        }
    }

    private static <Solution_> AbstractSolutionImporter<Solution_> createSolutionImporter(CommonApp<Solution_> commonApp) {
        Set importers = commonApp.createSolutionImporters();
        if (importers.size() != 1) {
            throw new IllegalStateException("The importers size (" + importers.size() + ") should be 1.");
        }
        return (AbstractSolutionImporter)importers.stream().findFirst().orElseThrow();
    }

    @Override
    protected List<File> getSolutionFiles(CommonApp<Solution_> commonApp) {
        return ImportDirSolveAllTurtleTest.getImportDirFiles(commonApp);
    }

    @Override
    protected SolveAllTurtleTest.ProblemFactory<Solution_> createProblemFactory(CommonApp<Solution_> commonApp) {
        AbstractSolutionImporter<Solution_> solutionImporter = ImportDirSolveAllTurtleTest.createSolutionImporter(commonApp);
        return arg_0 -> solutionImporter.readSolution(arg_0);
    }
}

