/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

public abstract class ImportDataFilesTest<Solution_>
extends LoggingTest {
    protected abstract AbstractSolutionImporter<Solution_> createSolutionImporter();

    protected abstract String getDataDirName();

    protected Predicate<File> dataFileInclusionFilter() {
        return file -> true;
    }

    private static List<File> getInputFiles(String dataDirName, AbstractSolutionImporter<?> solutionImporter) {
        File importDir = new File(CommonApp.determineDataDir((String)dataDirName), "import");
        return ImportDataFilesTest.getAllFilesRecursivelyAndSorted(importDir, arg_0 -> solutionImporter.acceptInputFile(arg_0));
    }

    @TestFactory
    @Execution(value=ExecutionMode.CONCURRENT)
    Stream<DynamicTest> readSolution() {
        AbstractSolutionImporter solutionImporter = this.createSolutionImporter();
        return ImportDataFilesTest.getInputFiles(this.getDataDirName(), solutionImporter).stream().filter(this.dataFileInclusionFilter()).map(importFile -> DynamicTest.dynamicTest((String)importFile.getName(), () -> solutionImporter.readSolution(importFile)));
    }
}

