/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.swingui.ConstraintMatchesDialog;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.swing.impl.TangoColorFactory;

public final class SolverAndPersistenceFrame<Solution_>
extends JFrame {
    public static final ImageIcon OPTAPLANNER_ICON = new ImageIcon(SolverAndPersistenceFrame.class.getResource("optaPlannerIcon.png"));
    private final SolutionBusiness<Solution_, ?> solutionBusiness;
    private final ImageIcon indictmentHeatMapTrueIcon;
    private final ImageIcon indictmentHeatMapFalseIcon;
    private final ImageIcon refreshScreenDuringSolvingTrueIcon;
    private final ImageIcon refreshScreenDuringSolvingFalseIcon;
    private final SolutionPanel<Solution_> solutionPanel;
    private final ConstraintMatchesDialog constraintMatchesDialog;
    private JList<QuickOpenAction> quickOpenUnsolvedJList;
    private JList<QuickOpenAction> quickOpenSolvedJList;
    private Action openAction;
    private Action saveAction;
    private Action importAction;
    private Action exportAction;
    private final Action[] extraActions;
    private JToggleButton refreshScreenDuringSolvingToggleButton;
    private JToggleButton indictmentHeatMapToggleButton;
    private Action solveAction;
    private JButton solveButton;
    private Action terminateSolvingEarlyAction;
    private JButton terminateSolvingEarlyButton;
    private JPanel middlePanel;
    private JProgressBar progressBar;
    private JTextField scoreField;
    private ShowConstraintMatchesDialogAction showConstraintMatchesDialogAction;

    public SolverAndPersistenceFrame(SolutionBusiness<Solution_, ?> solutionBusiness, SolutionPanel<Solution_> solutionPanel, CommonApp.ExtraAction<Solution_>[] extraActions) {
        super(solutionBusiness.getAppName() + " OptaPlanner example");
        this.solutionBusiness = solutionBusiness;
        this.solutionPanel = solutionPanel;
        this.setIconImage(OPTAPLANNER_ICON.getImage());
        solutionPanel.setSolutionBusiness(solutionBusiness);
        solutionPanel.setSolverAndPersistenceFrame(this);
        this.extraActions = (Action[])Arrays.stream(extraActions).map(a -> new AbstractAction(a.getName(), (CommonApp.ExtraAction)a, solutionBusiness, solutionPanel){
            final /* synthetic */ CommonApp.ExtraAction val$a;
            final /* synthetic */ SolutionBusiness val$solutionBusiness;
            final /* synthetic */ SolutionPanel val$solutionPanel;
            {
                this.val$a = extraAction;
                this.val$solutionBusiness = solutionBusiness;
                this.val$solutionPanel = solutionPanel;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$a.accept(this.val$solutionBusiness, this.val$solutionPanel);
            }
        }).toArray(Action[]::new);
        this.indictmentHeatMapTrueIcon = new ImageIcon(this.getClass().getResource("indictmentHeatMapTrueIcon.png"));
        this.indictmentHeatMapFalseIcon = new ImageIcon(this.getClass().getResource("indictmentHeatMapFalseIcon.png"));
        this.refreshScreenDuringSolvingTrueIcon = new ImageIcon(this.getClass().getResource("refreshScreenDuringSolvingTrueIcon.png"));
        this.refreshScreenDuringSolvingFalseIcon = new ImageIcon(this.getClass().getResource("refreshScreenDuringSolvingFalseIcon.png"));
        this.registerListeners();
        this.constraintMatchesDialog = new ConstraintMatchesDialog(this, solutionBusiness);
    }

    private void registerListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SolverAndPersistenceFrame.this.solutionBusiness.close();
            }
        });
    }

    private void bestSolutionChanged(Solution_ solution) {
        Object score = this.solutionBusiness.getScore();
        if (this.refreshScreenDuringSolvingToggleButton.isSelected()) {
            this.solutionPanel.updatePanel(solution);
            this.validate();
        }
        this.refreshScoreField((Score)score);
    }

    public void init(Component centerForComponent) {
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(centerForComponent);
    }

    private JComponent createContentPane() {
        JComponent quickOpenPanel = this.createQuickOpenPanel();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createToolBar(), "North");
        mainPanel.add((Component)this.createMiddlePanel(), "Center");
        mainPanel.add((Component)this.createScorePanel(), "South");
        JSplitPane splitPane = new JSplitPane(1, quickOpenPanel, mainPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.2);
        return splitPane;
    }

    private JComponent createQuickOpenPanel() {
        JSplitPane splitPane = new JSplitPane(0, this.createQuickOpenUnsolvedPanel(), this.createQuickOpenSolvedPanel());
        splitPane.setResizeWeight(0.8);
        splitPane.setBorder(null);
        return splitPane;
    }

    private JComponent createQuickOpenUnsolvedPanel() {
        this.quickOpenUnsolvedJList = new JList(new DefaultListModel());
        List<File> unsolvedFileList = this.solutionBusiness.getUnsolvedFileList();
        return this.createQuickOpenPanel(this.quickOpenUnsolvedJList, "Unsolved dataset shortcuts", unsolvedFileList);
    }

    private JComponent createQuickOpenSolvedPanel() {
        this.quickOpenSolvedJList = new JList(new DefaultListModel());
        List<File> solvedFileList = this.solutionBusiness.getSolvedFileList();
        return this.createQuickOpenPanel(this.quickOpenSolvedJList, "Solved dataset shortcuts", solvedFileList);
    }

    private JComponent createQuickOpenPanel(JList<QuickOpenAction> listPanel, String title, List<File> fileList) {
        listPanel.setSelectionMode(0);
        listPanel.addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int selectedIndex = listPanel.getSelectedIndex();
            if (selectedIndex < 0) {
                return;
            }
            QuickOpenAction action = (QuickOpenAction)listPanel.getModel().getElementAt(selectedIndex);
            action.actionPerformed(new ActionEvent(listPanel, -1, null));
        });
        this.refreshQuickOpenPanel(listPanel, fileList);
        JScrollPane scrollPane = new JScrollPane(listPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        scrollPane.setMinimumSize(new Dimension(100, 80));
        scrollPane.setPreferredSize(new Dimension(180, 200));
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel titleLabel = new JLabel(title);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        titlePanel.add((Component)titleLabel, "North");
        titlePanel.add((Component)scrollPane, "Center");
        return titlePanel;
    }

    private void refreshQuickOpenPanel(JList<QuickOpenAction> listPanel, List<File> fileList) {
        DefaultListModel model = (DefaultListModel)listPanel.getModel();
        model.clear();
        for (File file : fileList) {
            QuickOpenAction action = new QuickOpenAction(file);
            model.addElement(action);
            listPanel.clearSelection();
        }
    }

    private JComponent createToolBar() {
        JButton exportButton;
        JButton importButton;
        JPanel toolBar = new JPanel();
        GroupLayout toolBarLayout = new GroupLayout(toolBar);
        toolBar.setLayout(toolBarLayout);
        if (this.solutionBusiness.hasImporter()) {
            this.importAction = new ImportAction();
            importButton = new JButton(this.importAction);
        } else {
            importButton = null;
        }
        this.openAction = new OpenAction();
        this.openAction.setEnabled(true);
        JButton openButton = new JButton(this.openAction);
        this.saveAction = new SaveAction();
        this.saveAction.setEnabled(false);
        JButton saveButton = new JButton(this.saveAction);
        if (this.solutionBusiness.hasExporter()) {
            this.exportAction = new ExportAction();
            this.exportAction.setEnabled(false);
            exportButton = new JButton(this.exportAction);
        } else {
            exportButton = null;
        }
        JButton[] extraButtons = new JButton[this.extraActions.length];
        for (int i = 0; i < this.extraActions.length; ++i) {
            extraButtons[i] = new JButton(this.extraActions[i]);
        }
        this.progressBar = new JProgressBar(0, 100);
        JPanel solvePanel = new JPanel(new CardLayout());
        this.solveAction = new SolveAction();
        this.solveAction.setEnabled(false);
        this.solveButton = new JButton(this.solveAction);
        this.terminateSolvingEarlyAction = new TerminateSolvingEarlyAction();
        this.terminateSolvingEarlyAction.setEnabled(false);
        this.terminateSolvingEarlyButton = new JButton(this.terminateSolvingEarlyAction);
        this.terminateSolvingEarlyButton.setVisible(false);
        solvePanel.add((Component)this.solveButton, "solveAction");
        solvePanel.add((Component)this.terminateSolvingEarlyButton, "terminateSolvingEarlyAction");
        this.solveButton.setMinimumSize(this.terminateSolvingEarlyButton.getMinimumSize());
        this.solveButton.setPreferredSize(this.terminateSolvingEarlyButton.getPreferredSize());
        GroupLayout.SequentialGroup horizontalGroup = toolBarLayout.createSequentialGroup();
        if (this.solutionBusiness.hasImporter()) {
            horizontalGroup.addComponent(importButton);
        }
        horizontalGroup.addComponent(openButton);
        horizontalGroup.addComponent(saveButton);
        if (this.solutionBusiness.hasExporter()) {
            horizontalGroup.addComponent(exportButton);
        }
        for (JButton extraButton : extraButtons) {
            horizontalGroup.addComponent(extraButton);
        }
        horizontalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE);
        horizontalGroup.addComponent(solvePanel, -2, -2, -2);
        horizontalGroup.addComponent(this.progressBar, 20, -2, -2);
        toolBarLayout.setHorizontalGroup(horizontalGroup);
        GroupLayout.ParallelGroup verticalGroup = toolBarLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        if (this.solutionBusiness.hasImporter()) {
            verticalGroup.addComponent(importButton);
        }
        verticalGroup.addComponent(openButton);
        verticalGroup.addComponent(saveButton);
        if (this.solutionBusiness.hasExporter()) {
            verticalGroup.addComponent(exportButton);
        }
        for (JButton extraButton : extraButtons) {
            verticalGroup.addComponent(extraButton);
        }
        verticalGroup.addComponent(solvePanel);
        verticalGroup.addComponent(this.progressBar);
        toolBarLayout.setVerticalGroup(verticalGroup);
        return toolBar;
    }

    private JPanel createMiddlePanel() {
        this.middlePanel = new JPanel(new CardLayout());
        JPanel usageExplanationPanel = new JPanel(new BorderLayout(5, 5));
        ImageIcon usageExplanationIcon = new ImageIcon(this.getClass().getResource(this.solutionPanel.getUsageExplanationPath()));
        JLabel usageExplanationLabel = new JLabel(usageExplanationIcon);
        usageExplanationLabel.setMinimumSize(new Dimension(100, 100));
        usageExplanationPanel.add((Component)usageExplanationLabel, "Center");
        JPanel descriptionPanel = new JPanel(new BorderLayout(2, 2));
        descriptionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        descriptionPanel.add((Component)new JLabel("Example description"), "North");
        JTextArea descriptionTextArea = new JTextArea(8, 70);
        descriptionTextArea.setEditable(false);
        descriptionTextArea.setText(this.solutionBusiness.getAppDescription());
        descriptionPanel.add((Component)new JScrollPane(descriptionTextArea, 22, 30), "Center");
        usageExplanationPanel.add((Component)descriptionPanel, "South");
        this.middlePanel.add((Component)usageExplanationPanel, "usageExplanationPanel");
        JComponent wrappedSolutionPanel = this.solutionPanel.isWrapInScrollPane() ? new JScrollPane(this.solutionPanel) : this.solutionPanel;
        this.middlePanel.add(wrappedSolutionPanel, "solutionPanel");
        return this.middlePanel;
    }

    private JPanel createScorePanel() {
        JPanel scorePanel = new JPanel(new BorderLayout(5, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.showConstraintMatchesDialogAction = new ShowConstraintMatchesDialogAction();
        this.showConstraintMatchesDialogAction.setEnabled(false);
        buttonPanel.add(new JButton(this.showConstraintMatchesDialogAction));
        this.indictmentHeatMapToggleButton = new JToggleButton(this.solutionPanel.isUseIndictmentColor() ? this.indictmentHeatMapTrueIcon : this.indictmentHeatMapFalseIcon, this.solutionPanel.isUseIndictmentColor());
        this.indictmentHeatMapToggleButton.setEnabled(false);
        this.indictmentHeatMapToggleButton.setToolTipText("Show indictment heat map");
        this.indictmentHeatMapToggleButton.addActionListener(e -> {
            boolean selected = this.indictmentHeatMapToggleButton.isSelected();
            this.indictmentHeatMapToggleButton.setIcon(selected ? this.indictmentHeatMapTrueIcon : this.indictmentHeatMapFalseIcon);
            this.solutionPanel.setUseIndictmentColor(selected);
            this.resetScreen();
        });
        buttonPanel.add(this.indictmentHeatMapToggleButton);
        scorePanel.add((Component)buttonPanel, "West");
        this.scoreField = new JTextField("Score:");
        this.scoreField.setEditable(false);
        this.scoreField.setForeground(Color.BLACK);
        this.scoreField.setBorder(BorderFactory.createLoweredBevelBorder());
        scorePanel.add((Component)this.scoreField, "Center");
        this.refreshScreenDuringSolvingToggleButton = new JToggleButton(this.refreshScreenDuringSolvingTrueIcon, true);
        this.refreshScreenDuringSolvingToggleButton.setToolTipText("Refresh screen during solving");
        this.refreshScreenDuringSolvingToggleButton.addActionListener(e -> this.refreshScreenDuringSolvingToggleButton.setIcon(this.refreshScreenDuringSolvingToggleButton.isSelected() ? this.refreshScreenDuringSolvingTrueIcon : this.refreshScreenDuringSolvingFalseIcon));
        scorePanel.add((Component)this.refreshScreenDuringSolvingToggleButton, "East");
        return scorePanel;
    }

    public void setSolutionLoaded(Object eventSource) {
        if (eventSource != this.quickOpenUnsolvedJList) {
            this.quickOpenUnsolvedJList.clearSelection();
        }
        if (eventSource != this.quickOpenSolvedJList) {
            this.quickOpenSolvedJList.clearSelection();
        }
        this.setTitle(this.solutionBusiness.getAppName() + " - " + this.solutionBusiness.getSolutionFileName());
        ((CardLayout)this.middlePanel.getLayout()).show(this.middlePanel, "solutionPanel");
        this.setSolvingState(false);
        this.resetScreen();
    }

    private void setSolvingState(boolean solving) {
        this.quickOpenUnsolvedJList.setEnabled(!solving);
        this.quickOpenSolvedJList.setEnabled(!solving);
        if (this.solutionBusiness.hasImporter()) {
            this.importAction.setEnabled(!solving);
        }
        this.openAction.setEnabled(!solving);
        this.saveAction.setEnabled(!solving);
        if (this.solutionBusiness.hasExporter()) {
            this.exportAction.setEnabled(!solving);
        }
        this.solveAction.setEnabled(!solving);
        this.solveButton.setVisible(!solving);
        this.terminateSolvingEarlyAction.setEnabled(solving);
        this.terminateSolvingEarlyButton.setVisible(solving);
        if (solving) {
            this.terminateSolvingEarlyButton.requestFocus();
        } else {
            this.solveButton.requestFocus();
        }
        this.solutionPanel.setEnabled(!solving);
        this.progressBar.setIndeterminate(solving);
        this.progressBar.setStringPainted(solving);
        this.progressBar.setString(solving ? "Solving..." : null);
        this.indictmentHeatMapToggleButton.setEnabled(this.solutionPanel.isIndictmentHeatMapEnabled() && !solving);
        this.showConstraintMatchesDialogAction.setEnabled(!solving);
    }

    public void resetScreen() {
        Solution_ solution = this.solutionBusiness.getSolution();
        Object score = this.solutionBusiness.getScore();
        this.solutionPanel.resetPanel(solution);
        this.validate();
        this.refreshScoreField((Score)score);
    }

    public void refreshScoreField(Score score) {
        this.scoreField.setForeground(this.determineScoreFieldForeground(score));
        this.scoreField.setText("Latest best score: " + score);
    }

    private Color determineScoreFieldForeground(Score<?> score) {
        if (!score.isSolutionInitialized()) {
            return TangoColorFactory.SCARLET_3;
        }
        return score.isFeasible() ? TangoColorFactory.CHAMELEON_3 : TangoColorFactory.ORANGE_3;
    }

    private class QuickOpenAction
    extends AbstractAction {
        private final File file;

        public QuickOpenAction(File file) {
            super(file.getName().replaceAll("\\.json$|\\.xml$", ""));
            this.file = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SolverAndPersistenceFrame.this.solutionBusiness.openSolution(this.file);
                SolverAndPersistenceFrame.this.setSolutionLoaded(e.getSource());
            }
            finally {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public String toString() {
            return this.getValue("Name").toString();
        }
    }

    private class ImportAction
    extends AbstractAction {
        private static final String NAME = "Import...";
        private final JFileChooser fileChooser;

        public ImportAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("importAction.png")));
            if (!SolverAndPersistenceFrame.this.solutionBusiness.hasImporter()) {
                this.fileChooser = null;
                return;
            }
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getImportDataDir());
            boolean firstFilter = true;
            for (final AbstractSolutionImporter importer : SolverAndPersistenceFrame.this.solutionBusiness.getImporters()) {
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || importer.acceptInputFile(file);
                    }

                    @Override
                    public String getDescription() {
                        return "Import files (*." + importer.getInputFileSuffix() + ")";
                    }
                };
                this.fileChooser.addChoosableFileFilter(filter);
                if (!firstFilter) continue;
                this.fileChooser.setFileFilter(filter);
                firstFilter = false;
            }
            this.fileChooser.setDialogTitle(NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int approved = this.fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                File file = this.fileChooser.getSelectedFile();
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.importSolution(file);
                    SolverAndPersistenceFrame.this.setSolutionLoaded(e.getSource());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final String NAME = "Open...";
        private final JFileChooser fileChooser;

        public OpenAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("openAction.png")));
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            final String inputFileExtension = SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileIO().getOutputFileExtension();
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("." + inputFileExtension);
                }

                @Override
                public String getDescription() {
                    return "Solution files (*." + inputFileExtension + ")";
                }
            });
            this.fileChooser.setDialogTitle(NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int approved = this.fileChooser.showOpenDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.openSolution(this.fileChooser.getSelectedFile());
                    SolverAndPersistenceFrame.this.setSolutionLoaded(e.getSource());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final String NAME = "Save as...";
        private JFileChooser fileChooser;

        public SaveAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("saveAction.png")));
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir());
            final String outputFileExtension = SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileIO().getOutputFileExtension();
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("." + outputFileExtension);
                }

                @Override
                public String getDescription() {
                    return "Solution files (*." + outputFileExtension + ")";
                }
            });
            this.fileChooser.setDialogTitle(NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            String outputFileExtension = SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileIO().getOutputFileExtension();
            this.fileChooser.setSelectedFile(new File(SolverAndPersistenceFrame.this.solutionBusiness.getSolvedDataDir(), SolutionBusiness.getBaseFileName(SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileName()) + "." + outputFileExtension));
            int approved = this.fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    SolverAndPersistenceFrame.this.solutionBusiness.saveSolution(this.fileChooser.getSelectedFile());
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
                SolverAndPersistenceFrame.this.refreshQuickOpenPanel(SolverAndPersistenceFrame.this.quickOpenUnsolvedJList, SolverAndPersistenceFrame.this.solutionBusiness.getUnsolvedFileList());
                SolverAndPersistenceFrame.this.refreshQuickOpenPanel(SolverAndPersistenceFrame.this.quickOpenSolvedJList, SolverAndPersistenceFrame.this.solutionBusiness.getSolvedFileList());
                SolverAndPersistenceFrame.this.validate();
            }
        }
    }

    private class ExportAction
    extends AbstractAction {
        private static final String NAME = "Export as...";
        private final JFileChooser fileChooser;

        public ExportAction() {
            super(NAME, new ImageIcon(SolverAndPersistenceFrame.class.getResource("exportAction.png")));
            if (!SolverAndPersistenceFrame.this.solutionBusiness.hasExporter()) {
                this.fileChooser = null;
                return;
            }
            this.fileChooser = new JFileChooser(SolverAndPersistenceFrame.this.solutionBusiness.getExportDataDir());
            for (AbstractSolutionExporter exporter : SolverAndPersistenceFrame.this.solutionBusiness.getExporters()) {
                this.fileChooser.addChoosableFileFilter(new ExporterFileFilter(exporter));
            }
            this.fileChooser.setDialogTitle(NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.addPropertyChangeListener(new FileNameSetter(this.fileChooser, SolverAndPersistenceFrame.this.solutionBusiness.getExportDataDir(), SolutionBusiness.getBaseFileName(SolverAndPersistenceFrame.this.solutionBusiness.getSolutionFileName())));
            int approved = this.fileChooser.showSaveDialog(SolverAndPersistenceFrame.this);
            if (approved == 0) {
                SolverAndPersistenceFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    AbstractSolutionExporter exporter = ((ExporterFileFilter)this.fileChooser.getFileFilter()).getExporter();
                    File exportFile = this.fileChooser.getSelectedFile();
                    SolverAndPersistenceFrame.this.solutionBusiness.exportSolution(exporter, exportFile);
                }
                finally {
                    SolverAndPersistenceFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
            this.fileChooser.setSelectedFile(null);
        }
    }

    private class SolveAction
    extends AbstractAction {
        public SolveAction() {
            super("Solve", new ImageIcon(SolverAndPersistenceFrame.class.getResource("solveAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.setSolvingState(true);
            Object problem = SolverAndPersistenceFrame.this.solutionBusiness.getSolution();
            new SolveWorker(problem).execute();
        }
    }

    private class TerminateSolvingEarlyAction
    extends AbstractAction {
        public TerminateSolvingEarlyAction() {
            super("Terminate solving early", new ImageIcon(SolverAndPersistenceFrame.class.getResource("terminateSolvingEarlyAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.terminateSolvingEarlyAction.setEnabled(false);
            SolverAndPersistenceFrame.this.progressBar.setString("Terminating...");
            SolverAndPersistenceFrame.this.solutionBusiness.terminateSolvingEarly();
        }
    }

    private class ShowConstraintMatchesDialogAction
    extends AbstractAction {
        public ShowConstraintMatchesDialogAction() {
            super("Constraint matches", new ImageIcon(SolverAndPersistenceFrame.class.getResource("showConstraintMatchesDialogAction.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SolverAndPersistenceFrame.this.constraintMatchesDialog.resetContentPanel();
            SolverAndPersistenceFrame.this.constraintMatchesDialog.setVisible(true);
        }
    }

    private final class FileNameSetter
    implements PropertyChangeListener {
        private JFileChooser fileChooser;
        private File exportDataDir;
        private String baseName;

        public FileNameSetter(JFileChooser fileChooser, File exportDataDir, String baseName) {
            this.fileChooser = fileChooser;
            this.exportDataDir = exportDataDir;
            this.baseName = baseName;
            this.setFileName();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("SelectedFileChangedProperty".equals(prop)) {
                File file = (File)evt.getNewValue();
                if (file == null) {
                    this.setFileName();
                }
            } else if (prop.equals("fileFilterChanged")) {
                this.setFileName();
            }
        }

        void setFileName() {
            AbstractSolutionExporter exporter = ((ExporterFileFilter)this.fileChooser.getFileFilter()).getExporter();
            this.fileChooser.setSelectedFile(new File(this.exportDataDir, this.baseName + "." + exporter.getOutputFileSuffix()));
        }
    }

    private final class ExporterFileFilter
    extends FileFilter {
        private final AbstractSolutionExporter<Solution_> exporter;

        public ExporterFileFilter(AbstractSolutionExporter<Solution_> exporter) {
            this.exporter = exporter;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith("." + this.exporter.getOutputFileSuffix());
        }

        @Override
        public String getDescription() {
            return "Export files (*." + this.exporter.getOutputFileSuffix() + ")";
        }

        public AbstractSolutionExporter<Solution_> getExporter() {
            return this.exporter;
        }
    }

    protected class SolveWorker
    extends SwingWorker<Solution_, Void> {
        protected final Solution_ problem;

        public SolveWorker(Solution_ problem) {
            this.problem = problem;
        }

        @Override
        protected Solution_ doInBackground() {
            return SolverAndPersistenceFrame.this.solutionBusiness.solve(this.problem, x$0 -> SolverAndPersistenceFrame.this.bestSolutionChanged(x$0));
        }

        @Override
        protected void done() {
            try {
                Object bestSolution = this.get();
                SolverAndPersistenceFrame.this.solutionBusiness.setSolution(bestSolution);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Solving was interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Solving failed.", e.getCause());
            }
            finally {
                SolverAndPersistenceFrame.this.setSolvingState(false);
                SolverAndPersistenceFrame.this.resetScreen();
            }
        }
    }
}

