/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui.timetable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.timetable.TimeTableLayout;
import org.optaplanner.examples.common.swingui.timetable.TimeTableLayoutConstraints;

public final class TimeTablePanel<XObject, YObject>
extends JPanel
implements Scrollable {
    private final TimeTableLayout layout = new TimeTableLayout();
    private final Map<Object, Integer> xMap = new HashMap<Object, Integer>();
    private final Map<Object, Integer> yMap = new HashMap<Object, Integer>();

    public TimeTablePanel() {
        this.setLayout(this.layout);
    }

    public void reset() {
        this.removeAll();
        this.layout.reset();
        this.xMap.clear();
        this.yMap.clear();
    }

    public void defineColumnHeaderByKey(HeaderColumnKey xObject) {
        int x = this.layout.addColumn();
        this.xMap.put((Object)xObject, x);
    }

    public void defineColumnHeader(XObject xObject) {
        int x = this.layout.addColumn();
        this.xMap.put(xObject, x);
    }

    public void defineColumnHeader(XObject xObject, int width) {
        int x = this.layout.addColumn(width);
        this.xMap.put(xObject, x);
    }

    public void defineRowHeaderByKey(HeaderRowKey yObject) {
        int y = this.layout.addRow();
        this.yMap.put((Object)yObject, y);
    }

    public void defineRowHeader(YObject yObject) {
        int y = this.layout.addRow();
        this.yMap.put(yObject, y);
    }

    public void defineRowHeader(YObject yObject, int height) {
        int y = this.layout.addRow(height);
        this.yMap.put(yObject, y);
    }

    public void addCornerHeader(HeaderColumnKey xObject, HeaderRowKey yObject, JComponent component) {
        int x = this.xMap.get((Object)xObject);
        int y = this.yMap.get((Object)yObject);
        this.add((Component)component, new TimeTableLayoutConstraints(x, y, true));
    }

    public void addColumnHeader(XObject xObject, HeaderRowKey yObject, JComponent component) {
        int x = this.xMap.get(xObject);
        int y = this.yMap.get((Object)yObject);
        this.add((Component)component, new TimeTableLayoutConstraints(x, y, true));
    }

    public void addColumnHeader(XObject xObject1, HeaderRowKey yObject1, XObject xObject2, HeaderRowKey yObject2, JComponent component) {
        int x1 = this.xMap.get(xObject1);
        int y1 = this.yMap.get((Object)yObject1);
        int x2 = this.xMap.get(xObject2);
        int y2 = this.yMap.get((Object)yObject2);
        this.add((Component)component, new TimeTableLayoutConstraints(x1, y1, x2 - x1 + 1, y2 - y1 + 1, true));
    }

    public void addRowHeader(HeaderColumnKey xObject, YObject yObject, JComponent component) {
        int x = this.xMap.get((Object)xObject);
        int y = this.yMap.get(yObject);
        this.add((Component)component, new TimeTableLayoutConstraints(x, y, true));
    }

    public void addRowHeader(HeaderColumnKey xObject1, YObject yObject1, HeaderColumnKey xObject2, YObject yObject2, JComponent component) {
        int x1 = this.xMap.get((Object)xObject1);
        int y1 = this.yMap.get(yObject1);
        int x2 = this.xMap.get((Object)xObject2);
        int y2 = this.yMap.get(yObject2);
        this.add((Component)component, new TimeTableLayoutConstraints(x1, y1, x2 - x1 + 1, y2 - y1 + 1, true));
    }

    public void addCell(XObject xObject, YObject yObject, JComponent component) {
        int x = this.xMap.get(xObject);
        int y = this.yMap.get(yObject);
        this.add((Component)component, new TimeTableLayoutConstraints(x, y));
    }

    public void addCell(XObject xObject1, YObject yObject1, XObject xObject2, YObject yObject2, JComponent component) {
        int x1 = this.xMap.get(xObject1);
        int y1 = this.yMap.get(yObject1);
        int x2 = this.xMap.get(xObject2);
        int y2 = this.yMap.get(yObject2);
        this.add((Component)component, new TimeTableLayoutConstraints(x1, y1, x2 - x1 + 1, y2 - y1 + 1));
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return SolutionPanel.PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public static enum HeaderRowKey {
        HEADER_ROW_GROUP2,
        HEADER_ROW_GROUP1,
        HEADER_ROW,
        TRAILING_HEADER_ROW;

    }

    public static enum HeaderColumnKey {
        HEADER_COLUMN_GROUP2,
        HEADER_COLUMN_GROUP1,
        HEADER_COLUMN,
        HEADER_COLUMN_EXTRA_PROPERTY_1,
        HEADER_COLUMN_EXTRA_PROPERTY_2,
        HEADER_COLUMN_EXTRA_PROPERTY_3,
        HEADER_COLUMN_EXTRA_PROPERTY_4,
        HEADER_COLUMN_EXTRA_PROPERTY_5,
        TRAILING_HEADER_COLUMN;

    }
}

