/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.persistence;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractJsonSolutionFileIO;
import org.optaplanner.examples.taskassigning.domain.Affinity;
import org.optaplanner.examples.taskassigning.domain.Customer;
import org.optaplanner.examples.taskassigning.domain.Employee;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;

public class TaskAssigningSolutionFileIO
extends AbstractJsonSolutionFileIO<TaskAssigningSolution> {
    public TaskAssigningSolutionFileIO() {
        super(TaskAssigningSolution.class);
    }

    public TaskAssigningSolution read(File inputSolutionFile) {
        TaskAssigningSolution taskAssigningSolution = (TaskAssigningSolution)super.read(inputSolutionFile);
        Map customersById = taskAssigningSolution.getCustomerList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Employee employee : taskAssigningSolution.getEmployeeList()) {
            Map<Customer, Affinity> newTravelDistanceMap = this.deduplicateMap(employee.getAffinityMap(), customersById, AbstractPersistable::getId);
            employee.setAffinityMap(newTravelDistanceMap);
        }
        return taskAssigningSolution;
    }
}

