/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.score;

import java.util.Arrays;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.common.score.AbstractConstraintProviderTest;
import org.optaplanner.examples.common.score.ConstraintProviderTest;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.AirLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.score.VehicleRoutingConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

class VehicleRoutingConstraintProviderTest
extends AbstractConstraintProviderTest<VehicleRoutingConstraintProvider, VehicleRoutingSolution> {
    private final Location location1 = new AirLocation(1L, 0.0, 0.0);
    private final Location location2 = new AirLocation(2L, 0.0, 4.0);
    private final Location location3 = new AirLocation(3L, 3.0, 0.0);

    VehicleRoutingConstraintProviderTest() {
    }

    @ConstraintProviderTest
    void vehicleCapacityUnpenalized(ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier) {
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        Customer customer1 = new Customer(2L, this.location2, 80);
        VehicleRoutingConstraintProviderTest.connect(vehicleA, customer1);
        constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{vehicleA, customer1}).penalizesBy(0);
    }

    @ConstraintProviderTest
    void vehicleCapacityPenalized(ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier) {
        Customer customer1 = new Customer(2L, this.location2, 80);
        Customer customer2 = new Customer(3L, this.location3, 40);
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        VehicleRoutingConstraintProviderTest.connect(vehicleA, customer1, customer2);
        constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(20);
    }

    @ConstraintProviderTest
    void distanceToPreviousStandstill(ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier) {
        Customer customer1 = new Customer(2L, this.location2, 80);
        Customer customer2 = new Customer(3L, this.location3, 40);
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        VehicleRoutingConstraintProviderTest.connect(vehicleA, customer1, customer2);
        constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceToPreviousStandstill).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(9000L);
    }

    @ConstraintProviderTest
    void distanceFromLastCustomerToDepot(ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier) {
        Customer customer1 = new Customer(2L, this.location2, 80);
        Customer customer2 = new Customer(3L, this.location3, 40);
        Vehicle vehicleA = new Vehicle(1L, 100, new Depot(1L, this.location1));
        VehicleRoutingConstraintProviderTest.connect(vehicleA, customer1, customer2);
        constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromLastCustomerToDepot).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(3000L);
    }

    @ConstraintProviderTest
    void arrivalAfterDueTime(ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier) {
        TimeWindowedCustomer customer1 = new TimeWindowedCustomer(2L, this.location2, 1, 80000L, 180000L, 10000L);
        customer1.setArrivalTime(Long.valueOf(84000L));
        TimeWindowedCustomer customer2 = new TimeWindowedCustomer(3L, this.location3, 40, 80000L, 90000L, 10000L);
        customer2.setArrivalTime(Long.valueOf(99000L));
        Vehicle vehicleA = new Vehicle(1L, 100, (Depot)new TimeWindowedDepot(1L, this.location1, 80000L, 180000L));
        VehicleRoutingConstraintProviderTest.connect(vehicleA, new Customer[]{customer1, customer2});
        constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::arrivalAfterDueTime).given(new Object[]{vehicleA, customer1, customer2}).penalizesBy(9000L);
    }

    static void connect(Vehicle vehicle, Customer ... customers) {
        vehicle.setCustomers(Arrays.asList(customers));
        for (int i = 0; i < customers.length; ++i) {
            Customer customer = customers[i];
            customer.setVehicle(vehicle);
            if (i > 0) {
                customer.setPreviousCustomer(customers[i - 1]);
            }
            if (i >= customers.length - 1) continue;
            customer.setNextCustomer(customers[i + 1]);
        }
    }

    @Override
    protected ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> createConstraintVerifier() {
        return ConstraintVerifier.build((ConstraintProvider)new VehicleRoutingConstraintProvider(), VehicleRoutingSolution.class, (Class[])new Class[]{Vehicle.class});
    }
}

