/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tennis.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.tennis.domain.Day;
import org.optaplanner.examples.tennis.domain.Team;
import org.optaplanner.examples.tennis.domain.TeamAssignment;
import org.optaplanner.examples.tennis.domain.TennisSolution;
import org.optaplanner.examples.tennis.domain.UnavailabilityPenalty;
import org.optaplanner.examples.tennis.persistence.TennisSolutionFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class TennisGenerator
extends LoggingMain {
    protected final SolutionFileIO<TennisSolution> solutionFileIO = new TennisSolutionFileIO();
    protected final File outputDir = new File(CommonApp.determineDataDir("tennis"), "unsolved");

    public static void main(String[] args) {
        new TennisGenerator().generate();
    }

    public void generate() {
        File outputFile = new File(this.outputDir, "munich-7teams.json");
        TennisSolution tennisSolution = this.createTennisSolution();
        this.solutionFileIO.write((Object)tennisSolution, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }

    public TennisSolution createTennisSolution() {
        TennisSolution tennisSolution = new TennisSolution(0L);
        ArrayList<Team> teamList = new ArrayList<Team>();
        teamList.add(new Team(0L, "Micha"));
        teamList.add(new Team(1L, "Angelika"));
        teamList.add(new Team(2L, "Katrin"));
        teamList.add(new Team(3L, "Susi"));
        teamList.add(new Team(4L, "Irene"));
        teamList.add(new Team(5L, "Kristina"));
        teamList.add(new Team(6L, "Tobias"));
        tennisSolution.setTeamList(teamList);
        ArrayList<Day> dayList = new ArrayList<Day>();
        for (int i = 0; i < 18; ++i) {
            dayList.add(new Day(i, i));
        }
        tennisSolution.setDayList(dayList);
        ArrayList<UnavailabilityPenalty> unavailabilityPenaltyList = new ArrayList<UnavailabilityPenalty>();
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(0L, (Team)teamList.get(4), (Day)dayList.get(0)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(1L, (Team)teamList.get(6), (Day)dayList.get(1)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(2L, (Team)teamList.get(2), (Day)dayList.get(2)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(3L, (Team)teamList.get(4), (Day)dayList.get(3)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(4L, (Team)teamList.get(4), (Day)dayList.get(5)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(5L, (Team)teamList.get(2), (Day)dayList.get(6)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(6L, (Team)teamList.get(1), (Day)dayList.get(8)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(7L, (Team)teamList.get(2), (Day)dayList.get(9)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(8L, (Team)teamList.get(4), (Day)dayList.get(10)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(9L, (Team)teamList.get(4), (Day)dayList.get(11)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(10L, (Team)teamList.get(6), (Day)dayList.get(12)));
        unavailabilityPenaltyList.add(new UnavailabilityPenalty(11L, (Team)teamList.get(5), (Day)dayList.get(15)));
        tennisSolution.setUnavailabilityPenaltyList(unavailabilityPenaltyList);
        ArrayList<TeamAssignment> teamAssignmentList = new ArrayList<TeamAssignment>();
        long id = 0L;
        for (Day day : dayList) {
            for (int i = 0; i < 4; ++i) {
                teamAssignmentList.add(new TeamAssignment(id, day, i));
                ++id;
            }
        }
        tennisSolution.setTeamAssignmentList(teamAssignmentList);
        BigInteger possibleSolutionSize = BigInteger.valueOf(teamList.size()).pow(teamAssignmentList.size());
        this.logger.info("Tennis {} has {} teams, {} days, {} unavailabilityPenalties and {} teamAssignments with a search space of {}.", new Object[]{"munich-7teams", teamList.size(), dayList.size(), unavailabilityPenaltyList.size(), teamAssignmentList.size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return tennisSolution;
    }
}

