/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractJsonSolutionFileIO;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;

public class VehicleRoutingSolutionFileIO
extends AbstractJsonSolutionFileIO<VehicleRoutingSolution> {
    public VehicleRoutingSolutionFileIO() {
        super(VehicleRoutingSolution.class);
    }

    public VehicleRoutingSolution read(File inputSolutionFile) {
        VehicleRoutingSolution vehicleRoutingSolution = (VehicleRoutingSolution)super.read(inputSolutionFile);
        if (vehicleRoutingSolution.getDistanceType() == DistanceType.ROAD_DISTANCE) {
            this.deduplicateRoadLocations(vehicleRoutingSolution);
        } else if (vehicleRoutingSolution.getDistanceType() == DistanceType.SEGMENTED_ROAD_DISTANCE) {
            this.deduplicateRoadSegments(vehicleRoutingSolution);
        }
        return vehicleRoutingSolution;
    }

    private void deduplicateRoadLocations(VehicleRoutingSolution vehicleRoutingSolution) {
        List roadLocationList = vehicleRoutingSolution.getLocationList().stream().filter(location -> location instanceof RoadLocation).map(location -> (RoadLocation)location).collect(Collectors.toList());
        Map locationsById = roadLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (RoadLocation roadLocation : roadLocationList) {
            Map<RoadLocation, Double> newTravelDistanceMap = this.deduplicateMap(roadLocation.getTravelDistanceMap(), locationsById, AbstractPersistable::getId);
            roadLocation.setTravelDistanceMap(newTravelDistanceMap);
        }
    }

    private void deduplicateRoadSegments(VehicleRoutingSolution vehicleRoutingSolution) {
        Map<RoadSegmentLocation, Double> newNearbyTravelDistanceMap;
        Map<HubSegmentLocation, Double> newHubTravelDistanceMap;
        List hubSegmentLocationList = vehicleRoutingSolution.getLocationList().stream().filter(location -> location instanceof HubSegmentLocation).map(location -> (HubSegmentLocation)location).collect(Collectors.toList());
        List roadSegmentLocationList = vehicleRoutingSolution.getLocationList().stream().filter(location -> location instanceof RoadSegmentLocation).map(location -> (RoadSegmentLocation)location).collect(Collectors.toList());
        Map hubSegmentLocationsById = hubSegmentLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map roadSegmentLocationsById = roadSegmentLocationList.stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (HubSegmentLocation hubSegmentLocation : hubSegmentLocationList) {
            newHubTravelDistanceMap = this.deduplicateMap(hubSegmentLocation.getHubTravelDistanceMap(), hubSegmentLocationsById, AbstractPersistable::getId);
            newNearbyTravelDistanceMap = this.deduplicateMap(hubSegmentLocation.getNearbyTravelDistanceMap(), roadSegmentLocationsById, AbstractPersistable::getId);
            hubSegmentLocation.setHubTravelDistanceMap(newHubTravelDistanceMap);
            hubSegmentLocation.setNearbyTravelDistanceMap(newNearbyTravelDistanceMap);
        }
        for (RoadSegmentLocation roadSegmentLocation : roadSegmentLocationList) {
            newHubTravelDistanceMap = this.deduplicateMap(roadSegmentLocation.getHubTravelDistanceMap(), hubSegmentLocationsById, AbstractPersistable::getId);
            newNearbyTravelDistanceMap = this.deduplicateMap(roadSegmentLocation.getNearbyTravelDistanceMap(), roadSegmentLocationsById, AbstractPersistable::getId);
            roadSegmentLocation.setHubTravelDistanceMap(newHubTravelDistanceMap);
            roadSegmentLocation.setNearbyTravelDistanceMap(newNearbyTravelDistanceMap);
        }
    }
}

