/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.score;

import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.score.CloudBalancingConstraintProvider;
import org.optaplanner.examples.common.score.AbstractConstraintProviderTest;
import org.optaplanner.examples.common.score.ConstraintProviderTest;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;

class CloudBalancingConstraintProviderTest
extends AbstractConstraintProviderTest<CloudBalancingConstraintProvider, CloudBalance> {
    CloudBalancingConstraintProviderTest() {
    }

    @ConstraintProviderTest
    void requiredCpuPowerTotal(ConstraintVerifier<CloudBalancingConstraintProvider, CloudBalance> constraintVerifier) {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process1 = new CloudProcess(1L, 1, 1, 1);
        process1.setComputer(computer1);
        CloudProcess process2 = new CloudProcess(2L, 1, 1, 1);
        process2.setComputer(computer1);
        CloudProcess process3 = new CloudProcess(3L, 1, 1, 1);
        process3.setComputer(computer2);
        constraintVerifier.verifyThat(CloudBalancingConstraintProvider::requiredCpuPowerTotal).given(new Object[]{unassignedProcess, process1, process2, process3}).penalizesBy(1);
    }

    @ConstraintProviderTest
    void requiredMemoryTotal(ConstraintVerifier<CloudBalancingConstraintProvider, CloudBalance> constraintVerifier) {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process1 = new CloudProcess(1L, 1, 1, 1);
        process1.setComputer(computer1);
        CloudProcess process2 = new CloudProcess(2L, 1, 1, 1);
        process2.setComputer(computer1);
        CloudProcess process3 = new CloudProcess(3L, 1, 1, 1);
        process3.setComputer(computer2);
        constraintVerifier.verifyThat(CloudBalancingConstraintProvider::requiredMemoryTotal).given(new Object[]{unassignedProcess, process1, process2, process3}).penalizesBy(1);
    }

    @ConstraintProviderTest
    void requiredNetworkBandwidthTotal(ConstraintVerifier<CloudBalancingConstraintProvider, CloudBalance> constraintVerifier) {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process1 = new CloudProcess(1L, 1, 1, 1);
        process1.setComputer(computer1);
        CloudProcess process2 = new CloudProcess(2L, 1, 1, 1);
        process2.setComputer(computer1);
        CloudProcess process3 = new CloudProcess(3L, 1, 1, 1);
        process3.setComputer(computer2);
        constraintVerifier.verifyThat(CloudBalancingConstraintProvider::requiredNetworkBandwidthTotal).given(new Object[]{unassignedProcess, process1, process2, process3}).penalizesBy(1);
    }

    @ConstraintProviderTest
    void computerCost(ConstraintVerifier<CloudBalancingConstraintProvider, CloudBalance> constraintVerifier) {
        CloudComputer computer1 = new CloudComputer(1L, 1, 1, 1, 2);
        CloudComputer computer2 = new CloudComputer(2L, 2, 2, 2, 4);
        CloudProcess unassignedProcess = new CloudProcess(0L, 1, 1, 1);
        CloudProcess process = new CloudProcess(1L, 1, 1, 1);
        process.setComputer(computer1);
        constraintVerifier.verifyThat(CloudBalancingConstraintProvider::computerCost).given(new Object[]{computer1, computer2, unassignedProcess, process}).penalizesBy(2);
    }

    @Override
    protected ConstraintVerifier<CloudBalancingConstraintProvider, CloudBalance> createConstraintVerifier() {
        return ConstraintVerifier.build((ConstraintProvider)new CloudBalancingConstraintProvider(), CloudBalance.class, (Class[])new Class[]{CloudProcess.class});
    }
}

