/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.DistanceType;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.HubSegmentLocation;
import org.optaplanner.examples.vehiclerouting.domain.location.segmented.RoadSegmentLocation;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingSolutionFileIO;

class VehicleRoutingSolutionFileIOTest {
    private File solutionFile = null;

    VehicleRoutingSolutionFileIOTest() {
    }

    @BeforeEach
    void generateTempSolutionFile() throws IOException {
        VehicleRoutingSolution solution = VehicleRoutingSolutionFileIOTest.generateSolution();
        this.solutionFile = Files.createTempFile("optaplanner-", ".json", new FileAttribute[0]).toFile();
        VehicleRoutingSolutionFileIO solutionFileIO = new VehicleRoutingSolutionFileIO();
        solutionFileIO.write((Object)solution, this.solutionFile);
    }

    @Test
    void deserializeSegmentedLocations() throws IOException {
        VehicleRoutingSolution deserializedVehicleRoutingSolution = VehicleRoutingSolutionFileIOTest.readSolution(this.solutionFile);
        List deserializedLocationList = deserializedVehicleRoutingSolution.getLocationList();
        HubSegmentLocation deserializedDepotSegmentLocation = (HubSegmentLocation)deserializedLocationList.get(0);
        HubSegmentLocation deserializedCustomerSegmentLocation = (HubSegmentLocation)deserializedLocationList.get(1);
        RoadSegmentLocation deserializedRoadSegmentLocation = (RoadSegmentLocation)deserializedLocationList.get(2);
        Assertions.assertThat((Map)deserializedDepotSegmentLocation.getHubTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedDepotSegmentLocation.getNearbyTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedCustomerSegmentLocation.getHubTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedCustomerSegmentLocation.getNearbyTravelDistanceMap()).hasSize(1);
        Assertions.assertThat((Map)deserializedRoadSegmentLocation.getHubTravelDistanceMap()).hasSize(2);
        IdentityHashMap identityMap = new IdentityHashMap();
        deserializedLocationList.forEach(location -> identityMap.put(location, location));
        deserializedVehicleRoutingSolution.getCustomerList().forEach(customer -> identityMap.put(customer.getLocation(), customer.getLocation()));
        deserializedDepotSegmentLocation.getHubTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedDepotSegmentLocation.getNearbyTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedCustomerSegmentLocation.getHubTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedCustomerSegmentLocation.getNearbyTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        deserializedRoadSegmentLocation.getHubTravelDistanceMap().keySet().forEach(segmentLocation -> identityMap.put(segmentLocation, segmentLocation));
        Assertions.assertThat(identityMap).hasSize(3);
    }

    private static VehicleRoutingSolution generateSolution() {
        HubSegmentLocation depotLocation = new HubSegmentLocation(0L);
        HubSegmentLocation customerLocation = new HubSegmentLocation(1L);
        RoadSegmentLocation roadSegmentLocation = new RoadSegmentLocation(2L);
        depotLocation.setNearbyTravelDistanceMap(Map.of(roadSegmentLocation, 1.0));
        depotLocation.setHubTravelDistanceMap(Map.of(customerLocation, 2.0));
        customerLocation.setNearbyTravelDistanceMap(Map.of(roadSegmentLocation, 3.0));
        customerLocation.setHubTravelDistanceMap(Map.of(depotLocation, 4.0));
        roadSegmentLocation.setHubTravelDistanceMap(Map.of(depotLocation, 5.0, customerLocation, 6.0));
        Depot depot = new Depot(0L, (Location)depotLocation);
        Vehicle vehicle = new Vehicle(0L, 1, depot);
        Customer customer = new Customer(0L, (Location)customerLocation, 1);
        customer.setVehicle(vehicle);
        vehicle.setCustomers(List.of(customer));
        VehicleRoutingSolution vehicleRoutingSolution = new VehicleRoutingSolution();
        vehicleRoutingSolution.setName("Dummy VRP");
        vehicleRoutingSolution.setDistanceType(DistanceType.SEGMENTED_ROAD_DISTANCE);
        vehicleRoutingSolution.setLocationList(List.of(depotLocation, customerLocation, roadSegmentLocation));
        vehicleRoutingSolution.setDepotList(List.of(depot));
        vehicleRoutingSolution.setVehicleList(List.of(vehicle));
        vehicleRoutingSolution.setCustomerList(List.of(customer));
        return vehicleRoutingSolution;
    }

    private static VehicleRoutingSolution readSolution(File solutionFile) throws IOException {
        try {
            VehicleRoutingSolutionFileIO solutionFileIO = new VehicleRoutingSolutionFileIO();
            return solutionFileIO.read(solutionFile);
        }
        catch (Exception e) {
            throw new IOException("Unable to read the test resource ( " + solutionFile + " ).", e);
        }
    }
}

