/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.api.score;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.persistence.jackson.api.AbstractJacksonJsonSerializerAndDeserializerTest;

public abstract class AbstractScoreJacksonJsonSerializerAndDeserializerTest
extends AbstractJacksonJsonSerializerAndDeserializerTest {
    protected <S extends Score, W extends TestScoreWrapper<S>> void assertSerializeAndDeserialize(S expectedScore, W input) {
        TestScoreWrapper output;
        String jsonString;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            jsonString = objectMapper.writeValueAsString(input);
            output = (TestScoreWrapper)objectMapper.readValue(jsonString, input.getClass());
        }
        catch (IOException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assertions.assertThat(output.getScore()).isEqualTo(expectedScore);
        String regex = expectedScore != null ? "\\{\\s*\"score\":\"" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "\"\\s*\\}" : "\\{\"score\":null\\}";
        if (!jsonString.matches(regex)) {
            Assertions.fail((String)("Regular expression match failed.\nExpected regular expression: " + regex + "\nActual string: " + jsonString));
        }
    }

    public static abstract class TestScoreWrapper<S extends Score>
    implements Serializable {
        public abstract S getScore();
    }
}

