/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.impl.domain.solution;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class JacksonSolutionFileIO<Solution_>
implements SolutionFileIO<Solution_> {
    private final Class<Solution_> clazz;
    private final ObjectMapper mapper;

    public JacksonSolutionFileIO(Class<Solution_> clazz) {
        this(clazz, new ObjectMapper());
    }

    public JacksonSolutionFileIO(Class<Solution_> clazz, ObjectMapper mapper) {
        this.clazz = clazz;
        this.mapper = mapper;
    }

    public String getInputFileExtension() {
        return "json";
    }

    public String getOutputFileExtension() {
        return "json";
    }

    public Solution_ read(File inputSolutionFile) {
        try {
            return (Solution_)this.mapper.readValue(inputSolutionFile, this.clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(Solution_ solution, File file) {
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(file, solution);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed write", e);
        }
    }
}

