/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jackson.impl.domain.solution;

import java.io.File;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.testdata.util.CodeAssertable;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;
import org.optaplanner.persistence.jackson.impl.domain.solution.JacksonSolutionFileIO;
import org.optaplanner.persistence.jackson.impl.testdata.domain.JacksonTestdataEntity;
import org.optaplanner.persistence.jackson.impl.testdata.domain.JacksonTestdataSolution;
import org.optaplanner.persistence.jackson.impl.testdata.domain.JacksonTestdataValue;

public class JacksonSolutionFileIOTest {
    private static File solutionTestDir;

    @BeforeAll
    public static void setup() {
        solutionTestDir = new File("target/solutionTest/");
        solutionTestDir.mkdirs();
    }

    @Test
    public void readAndWrite() {
        JacksonSolutionFileIO solutionFileIO = new JacksonSolutionFileIO(JacksonTestdataSolution.class);
        File file = new File(solutionTestDir, "testdataSolution.json");
        JacksonTestdataSolution original = new JacksonTestdataSolution("s1");
        JacksonTestdataValue originalV1 = new JacksonTestdataValue("v1");
        original.setValueList(Arrays.asList(originalV1, new JacksonTestdataValue("v2")));
        original.setEntityList(Arrays.asList(new JacksonTestdataEntity("e1"), new JacksonTestdataEntity("e2", originalV1), new JacksonTestdataEntity("e3")));
        original.setScore(SimpleScore.of((int)-321));
        solutionFileIO.write((Object)original, file);
        JacksonTestdataSolution copy = (JacksonTestdataSolution)solutionFileIO.read(file);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)original);
        PlannerAssert.assertCode((String)"s1", (CodeAssertable)copy);
        PlannerAssert.assertAllCodesOfIterator(copy.getValueList().iterator(), (String[])new String[]{"v1", "v2"});
        PlannerAssert.assertAllCodesOfIterator(copy.getEntityList().iterator(), (String[])new String[]{"e1", "e2", "e3"});
        JacksonTestdataValue copyV1 = copy.getValueList().get(0);
        JacksonTestdataEntity copyE2 = copy.getEntityList().get(1);
        PlannerAssert.assertCode((String)"v1", (CodeAssertable)copyE2.getValue());
        Assertions.assertThat((Object)copyE2.getValue()).isSameAs((Object)copyV1);
        Assertions.assertThat((Comparable)copy.getScore()).isEqualTo((Object)SimpleScore.of((int)-321));
    }
}

