/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jaxb.api.score;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.optaplanner.core.api.score.Score;

public abstract class AbstractScoreJaxbXmlAdapterTest {
    protected <S extends Score, W extends TestScoreWrapper<S>> void assertSerializeAndDeserialize(S expectedScore, W input) {
        this.assertSerializeAndDeserializeXML(expectedScore, input);
        this.assertSerializeAndDeserializeJson(expectedScore, input);
    }

    protected <S extends Score, W extends TestScoreWrapper<S>> void assertSerializeAndDeserializeXML(S expectedScore, W input) {
        TestScoreWrapper output;
        String xmlString;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{input.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            jaxbMarshaller.marshal(input, (Writer)writer);
            xmlString = writer.toString();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xmlString);
            output = (TestScoreWrapper)unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assert.assertEquals(expectedScore, output.getScore());
        String regex = expectedScore != null ? "<\\?[^\\?]*\\?><([\\w\\-\\.]+)>\\s*<score>" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "</score>\\s*</\\1>" : "<\\?[^\\?]*\\?><([\\w\\-\\.]+)/>";
        if (!xmlString.matches(regex)) {
            Assert.fail((String)("Regular expression match failed.\nExpected regular expression: " + regex + "\nActual string: " + xmlString));
        }
    }

    protected <S extends Score, W extends TestScoreWrapper<S>> void assertSerializeAndDeserializeJson(S expectedScore, W input) {
        TestScoreWrapper output;
        String jsonString;
        System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{input.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            jaxbMarshaller.setProperty("eclipselink.json.include-root", (Object)true);
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter writer = new StringWriter();
            jaxbMarshaller.marshal(input, (Writer)writer);
            jsonString = writer.toString();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            unmarshaller.setProperty("eclipselink.json.include-root", (Object)true);
            StringReader reader = new StringReader(jsonString);
            output = (TestScoreWrapper)unmarshaller.unmarshal((Reader)reader);
            System.clearProperty("javax.xml.bind.context.factory");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assert.assertEquals(expectedScore, output.getScore());
        String regex = expectedScore != null ? "\\{\n\\s*\"([\\w]+)\"\\s:\\s\\{\n\\s*\"score\"\\s:\\s\"" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "\"\\s*\\}\n\\}" : "\\{\n\\s*\"([\\w]+)\"\\s:\\s\\{\n\\s*\\}\n\\}";
        if (!jsonString.matches(regex)) {
            Assert.fail((String)("Regular expression match failed.\nExpected regular expression: " + regex + "\nActual string: " + jsonString));
        }
    }

    public static abstract class TestScoreWrapper<S extends Score>
    implements Serializable {
        public abstract S getScore();
    }
}

