/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jaxb.api.score;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.io.jaxb.GenericJaxbIO;
import org.optaplanner.persistence.jaxb.api.score.PolymorphicScoreJaxbAdapter;

public class PolymorphicScoreJaxbAdapterTest {
    private final PolymorphicScoreJaxbAdapter scoreJaxbAdapter = new PolymorphicScoreJaxbAdapter();

    @Test
    public void marshall() {
        SimpleScore score = SimpleScore.of((int)1);
        PolymorphicScoreJaxbAdapter.JaxbAdaptedScore adaptedScore = this.scoreJaxbAdapter.marshal((Score)score);
        Assertions.assertThat((String)adaptedScore.getScoreClassName()).isEqualTo(SimpleScore.class.getName());
        Assertions.assertThat((String)adaptedScore.getScoreString()).isEqualTo(score.toString());
    }

    @Test
    public void unmarshall() {
        String xmlString = "<dummy><score class=\"org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore\">-1hard/-10soft</score></dummy>";
        GenericJaxbIO xmlIO = new GenericJaxbIO(DummyRootElement.class);
        DummyRootElement dummyRootElement = (DummyRootElement)xmlIO.read((Reader)new StringReader(xmlString));
        ((ObjectAssert)Assertions.assertThat((Object)dummyRootElement.score).isNotNull()).isEqualTo((Object)HardSoftLongScore.of((long)-1L, (long)-10L));
    }

    @XmlRootElement(name="dummy")
    private static class DummyRootElement {
        @XmlJavaTypeAdapter(value=PolymorphicScoreJaxbAdapter.class)
        private Score<?> score;

        private DummyRootElement() {
        }

        private DummyRootElement(Score<?> score) {
            this.score = score;
        }
    }
}

