/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jpa.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.kie.test.util.db.PersistenceUtil;
import org.optaplanner.core.api.score.Score;

public abstract class AbstractScoreJpaTest {
    private static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    protected Map<String, Object> context;
    protected EntityManagerFactory entityManagerFactory;
    protected TransactionManager transactionManager;

    @BeforeEach
    public void setUp() throws Exception {
        this.createH2DatabaseIfNeeded();
        this.context = PersistenceUtil.setupWithPoolingDataSource((String)"org.optaplanner.persistence.jpa.test");
        this.entityManagerFactory = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.transactionManager = (TransactionManager)InitialContext.doLookup("java:comp/TransactionManager");
    }

    private void createH2DatabaseIfNeeded() throws Exception {
        Properties databaseProperties = this.readDatabaseProperties();
        String jdbcUrl = databaseProperties.getProperty("url", "");
        if (jdbcUrl.startsWith("jdbc:h2")) {
            String regex = ":\\/\\/\\w+\\/(.*)";
            Pattern pattern = Pattern.compile(":\\/\\/\\w+\\/(.*)", 8);
            Matcher matcher = pattern.matcher(jdbcUrl);
            if (!matcher.find()) {
                throw new IllegalStateException("Unable to detect H2 database name. Cannot setup the test environment.");
            }
            String embeddedH2Url = "jdbc:h2:" + matcher.group(1);
            Connection connection = DriverManager.getConnection(embeddedH2Url);
            if (connection != null) {
                connection.close();
            }
        }
    }

    private Properties readDatabaseProperties() {
        Properties properties;
        block9: {
            Properties properties2 = new Properties();
            InputStream propertiesInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
            try {
                if (propertiesInputStream == null) {
                    throw new IllegalStateException("Unable to locate /datasource.properties. Cannot setup the test environment.");
                }
                properties2.load(propertiesInputStream);
                properties = properties2;
                if (propertiesInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesInputStream != null) {
                        try {
                            propertiesInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("Unable to open /datasource.properties. Cannot setup the test environment.");
                }
            }
            propertiesInputStream.close();
        }
        return properties;
    }

    @AfterEach
    public void tearDown() {
        PersistenceUtil.cleanUp(this.context);
    }

    protected <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> Long persistAndAssert(E jpaEntity) {
        try {
            this.transactionManager.begin();
            EntityManager em = this.entityManagerFactory.createEntityManager();
            em.persist(jpaEntity);
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException("Transaction failed.", e);
        }
        Long id = jpaEntity.getId();
        Assertions.assertThat((Long)id).isNotNull();
        return id;
    }

    @SafeVarargs
    protected final <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> void persistAndMerge(E jpaEntity, Score_ ... newScores) {
        Long id = this.persistAndAssert(jpaEntity);
        Class<?> jpaEntityClass = jpaEntity.getClass();
        Score_ oldScore = jpaEntity.getScore();
        for (Score_ newScore : newScores) {
            this.findAssertAndChangeScore((Class<E>)jpaEntityClass, id, oldScore, newScore);
            this.findAndAssert((Class<E>)jpaEntityClass, id, newScore);
            oldScore = newScore;
        }
    }

    protected <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> void findAssertAndChangeScore(Class<E> jpaEntityClass, Long id, Score_ oldScore, Score_ newScore) {
        try {
            this.transactionManager.begin();
            EntityManager em = this.entityManagerFactory.createEntityManager();
            AbstractTestJpaEntity jpaEntity = (AbstractTestJpaEntity)em.find(jpaEntityClass, (Object)id);
            em.persist((Object)jpaEntity);
            Assertions.assertThat(jpaEntity.getScore()).isEqualTo(oldScore);
            jpaEntity.setScore(newScore);
            jpaEntity = (AbstractTestJpaEntity)em.merge((Object)jpaEntity);
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException("Transaction failed.", e);
        }
    }

    protected <Score_ extends Score<Score_>, E extends AbstractTestJpaEntity<Score_>> void findAndAssert(Class<E> jpaEntityClass, Long id, Score_ score) {
        try {
            this.transactionManager.begin();
            EntityManager em = this.entityManagerFactory.createEntityManager();
            AbstractTestJpaEntity jpaEntity = (AbstractTestJpaEntity)em.find(jpaEntityClass, (Object)id);
            Assertions.assertThat(jpaEntity.getScore()).isEqualTo(score);
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
            throw new RuntimeException("Transaction failed.", e);
        }
    }

    @MappedSuperclass
    protected static abstract class AbstractTestJpaEntity<Score_ extends Score<Score_>> {
        @Id
        @GeneratedValue(strategy=GenerationType.AUTO)
        protected Long id;

        protected AbstractTestJpaEntity() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public abstract Score_ getScore();

        public abstract void setScore(Score_ var1);
    }
}

