/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jsonb.api;

import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.persistence.jsonb.api.AbstractJsonbJsonAdapterTest;
import org.optaplanner.persistence.jsonb.api.OptaPlannerJsonbConfig;

public class OptaPlannerJsonbConfigTest
extends AbstractJsonbJsonAdapterTest {
    @Test
    public void jsonbConfigSerializeAndDeserialize() {
        JsonbConfig config = OptaPlannerJsonbConfig.createConfig();
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        TestOptaPlannerJsonbConfigWrapper input = new TestOptaPlannerJsonbConfigWrapper();
        input.setBendableScore(BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}));
        input.setHardSoftScore(HardSoftScore.of((int)-1, (int)-20));
        TestOptaPlannerJsonbConfigWrapper output = OptaPlannerJsonbConfigTest.serializeAndDeserialize(jsonb, input);
        Assert.assertEquals((Object)BendableScore.of((int[])new int[]{1000, 200}, (int[])new int[]{34}), (Object)output.getBendableScore());
        Assert.assertEquals((Object)HardSoftScore.of((int)-1, (int)-20), (Object)output.getHardSoftScore());
    }

    public static class TestOptaPlannerJsonbConfigWrapper {
        private BendableScore bendableScore;
        private HardSoftScore hardSoftScore;

        public BendableScore getBendableScore() {
            return this.bendableScore;
        }

        public void setBendableScore(BendableScore bendableScore) {
            this.bendableScore = bendableScore;
        }

        public HardSoftScore getHardSoftScore() {
            return this.hardSoftScore;
        }

        public void setHardSoftScore(HardSoftScore hardSoftScore) {
            this.hardSoftScore = hardSoftScore;
        }
    }
}

