/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jsonb.api.score;

import java.io.Serializable;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;
import org.junit.Assert;
import org.optaplanner.core.api.score.Score;

public class AbstractScoreJsonbAdapterTest {
    protected <S extends Score, W extends TestScoreWrapper<S>> void assertSerializeAndDeserialize(S expectedScore, W input) {
        TestScoreWrapper output;
        String jsonString;
        try {
            Jsonb jsonb = JsonbBuilder.create();
            jsonString = jsonb.toJson(input);
            output = (TestScoreWrapper)jsonb.fromJson(jsonString, input.getClass());
        }
        catch (JsonbException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assert.assertEquals(expectedScore, output.getScore());
        String newLine = System.lineSeparator();
        String regex = expectedScore != null ? "\\{\"score\":\"" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "\"\\}" : "\\{\\}";
        if (!jsonString.matches(regex)) {
            Assert.fail((String)("Regular expression match failed." + newLine + "Expected regular expression: " + regex + newLine + "Actual string: " + jsonString));
        }
    }

    public static abstract class TestScoreWrapper<S extends Score>
    implements Serializable {
        public abstract S getScore();

        public abstract void setScore(S var1);
    }
}

