/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jsonb.api.score;

import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;
import org.assertj.core.api.Assertions;
import org.optaplanner.core.api.score.Score;

public class AbstractScoreJsonbAdapterTest {
    protected <Score_ extends Score<Score_>, W extends TestScoreWrapper<Score_>> void assertSerializeAndDeserialize(Score_ expectedScore, W input) {
        TestScoreWrapper output;
        String jsonString;
        try {
            Jsonb jsonb = JsonbBuilder.create();
            jsonString = jsonb.toJson(input);
            output = (TestScoreWrapper)jsonb.fromJson(jsonString, input.getClass());
        }
        catch (JsonbException e) {
            throw new IllegalStateException("Marshalling or unmarshalling for input (" + input + ") failed.", e);
        }
        Assertions.assertThat(output.getScore()).isEqualTo(expectedScore);
        String newLine = System.lineSeparator();
        String regex = expectedScore != null ? "\\{\"score\":\"" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "\"\\}" : "\\{\\}";
        if (!jsonString.matches(regex)) {
            Assertions.fail((String)("Regular expression match failed." + newLine + "Expected regular expression: " + regex + newLine + "Actual string: " + jsonString));
        }
    }

    public static abstract class TestScoreWrapper<Score_ extends Score<Score_>> {
        public abstract Score_ getScore();

        public abstract void setScore(Score_ var1);
    }
}

