/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import org.jboss.logging.Logger;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.quarkus.OptaPlannerBenchmarkBeanProvider;
import org.optaplanner.benchmark.quarkus.OptaPlannerBenchmarkRecorder;
import org.optaplanner.benchmark.quarkus.UnavailableOptaPlannerBenchmarkBeanProvider;
import org.optaplanner.benchmark.quarkus.deployment.OptaPlannerBenchmarkBuildTimeConfig;
import org.optaplanner.quarkus.deployment.SolverConfigBuildItem;

class OptaPlannerBenchmarkProcessor {
    private static final Logger log = Logger.getLogger((String)OptaPlannerBenchmarkProcessor.class.getName());
    OptaPlannerBenchmarkBuildTimeConfig optaPlannerBenchmarkBuildTimeConfig;

    OptaPlannerBenchmarkProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("optaplanner-benchmark");
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchSolverBenchmarkConfigXml() {
        String solverBenchmarkConfigXML = this.optaPlannerBenchmarkBuildTimeConfig.solverBenchmarkConfigXml.orElse("solverBenchmarkConfig.xml");
        return new HotDeploymentWatchedFileBuildItem(solverBenchmarkConfigXML);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SolverConfigBuildItem solverConfigBuildItem, OptaPlannerBenchmarkRecorder recorder) {
        PlannerBenchmarkConfig benchmarkConfig;
        if (solverConfigBuildItem.getSolverConfig() == null) {
            log.warn((Object)"Skipping OptaPlanner Benchmark extension because the OptaPlanner extension was skipped.");
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{UnavailableOptaPlannerBenchmarkBeanProvider.class}));
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.optaPlannerBenchmarkBuildTimeConfig.solverBenchmarkConfigXml.isPresent()) {
            String solverBenchmarkConfigXML = this.optaPlannerBenchmarkBuildTimeConfig.solverBenchmarkConfigXml.get();
            if (classLoader.getResource(solverBenchmarkConfigXML) == null) {
                throw new ConfigurationException("Invalid quarkus.optaplanner.benchmark.solver-benchmark-config-xml property (" + solverBenchmarkConfigXML + "): that classpath resource does not exist.");
            }
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)solverBenchmarkConfigXML);
        } else {
            benchmarkConfig = classLoader.getResource("solverBenchmarkConfig.xml") != null ? PlannerBenchmarkConfig.createFromXmlResource((String)"solverBenchmarkConfig.xml") : new PlannerBenchmarkConfig();
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(PlannerBenchmarkConfig.class).supplier(recorder.benchmarkConfigSupplier(benchmarkConfig)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{OptaPlannerBenchmarkBeanProvider.class}));
    }
}

