/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.benchmark.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.benchmark.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

public class OptaPlannerBenchmarkProcessorNoBenchmarkConfigTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.benchmark.solver.termination.spent-limit", "5s").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class}));
    @Inject
    PlannerBenchmarkFactory benchmarkFactory;

    @Test
    public void benchmark() throws ExecutionException, InterruptedException {
        TestdataQuarkusSolution problem = new TestdataQuarkusSolution();
        problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
        problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataQuarkusEntity()).collect(Collectors.toList()));
        this.benchmarkFactory.buildPlannerBenchmark((Object[])new TestdataQuarkusSolution[]{problem}).benchmark();
    }
}

