/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.quarkus.constraints.TestdataPlanningConstraintProvider;
import org.optaplanner.quarkus.domain.TestdataPlanningEntity;
import org.optaplanner.quarkus.domain.TestdataPlanningSolution;

public class OptaPlannerProcessorSolveTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataPlanningEntity.class, TestdataPlanningSolution.class, TestdataPlanningConstraintProvider.class}));
    @Inject
    SolverFactory<TestdataPlanningSolution> solverFactory;
    @Inject
    SolverManager<TestdataPlanningSolution, Long> solverManager;
    @Inject
    ScoreManager<TestdataPlanningSolution> scoreManager;

    @Test
    public void singletonSolverFactory() {
        Assertions.assertNotNull(this.solverFactory);
        Assertions.assertNotNull(this.scoreManager);
        Assertions.assertNotNull(this.solverManager);
        Assertions.assertSame(this.solverFactory, (Object)((DefaultSolverManager)this.solverManager).getSolverFactory());
    }

    @Test
    public void solve() throws ExecutionException, InterruptedException {
        TestdataPlanningSolution problem = new TestdataPlanningSolution();
        problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
        problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataPlanningEntity()).collect(Collectors.toList()));
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)problem);
        TestdataPlanningSolution solution = (TestdataPlanningSolution)solverJob.getFinalBestSolution();
        Assertions.assertNotNull((Object)solution);
        Assertions.assertTrue((solution.getScore().getScore() >= 0 ? 1 : 0) != 0);
    }
}

