/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.Collections;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.quarkus.constraints.TestdataPlanningConstraintProvider;
import org.optaplanner.quarkus.domain.TestdataPlanningEntity;
import org.optaplanner.quarkus.domain.TestdataPlanningSolution;

public class OptaPlannerProcessorXMLPropertyTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver-config-xml", "org/optaplanner/quarkus/customSolverConfig.xml").setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataPlanningEntity.class, TestdataPlanningSolution.class, TestdataPlanningConstraintProvider.class})).addAsResource("org/optaplanner/quarkus/customSolverConfig.xml"));
    @Inject
    SolverConfig solverConfig;
    @Inject
    SolverFactory<TestdataPlanningSolution> solverFactory;

    @Test
    public void solverConfigXml_property() {
        Assertions.assertNotNull((Object)this.solverConfig);
        Assertions.assertEquals(TestdataPlanningSolution.class, (Object)this.solverConfig.getSolutionClass());
        Assertions.assertEquals(Collections.singletonList(TestdataPlanningEntity.class), (Object)this.solverConfig.getEntityClassList());
        Assertions.assertEquals(TestdataPlanningConstraintProvider.class, (Object)this.solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass());
        Assertions.assertEquals((long)3L, (long)this.solverConfig.getTerminationConfig().getSecondsSpentLimit());
        Assertions.assertNotNull(this.solverFactory);
        Assertions.assertNotNull((Object)this.solverFactory.buildSolver());
    }
}

