/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.quarkus.testdata.gizmo.DummyConstraintProvider;
import org.optaplanner.quarkus.testdata.gizmo.DummyVariableListener;
import org.optaplanner.quarkus.testdata.gizmo.TestDataKitchenSinkEntity;
import org.optaplanner.quarkus.testdata.gizmo.TestDataKitchenSinkSolution;

class OptaPlannerProcessorGizmoKitchenSinkTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0hard/0soft").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestDataKitchenSinkEntity.class, TestDataKitchenSinkSolution.class, DummyConstraintProvider.class, DummyVariableListener.class}));
    @Inject
    SolverFactory<TestDataKitchenSinkSolution> solverFactory;
    @Inject
    SolverManager<TestDataKitchenSinkSolution, Long> solverManager;
    @Inject
    ScoreManager<TestDataKitchenSinkSolution, SimpleScore> scoreManager;

    OptaPlannerProcessorGizmoKitchenSinkTest() {
    }

    @Test
    void singletonSolverFactory() {
        Assertions.assertNotNull(this.solverFactory);
        Assertions.assertNotNull(this.solverManager);
        Assertions.assertSame(this.solverFactory, (Object)((DefaultSolverManager)this.solverManager).getSolverFactory());
        Assertions.assertNotNull(this.scoreManager);
    }

    @Test
    void solve() throws ExecutionException, InterruptedException {
        TestDataKitchenSinkSolution problem = new TestDataKitchenSinkSolution(new TestDataKitchenSinkEntity(), Collections.emptyList(), "Test", Collections.emptyList(), HardSoftLongScore.ZERO);
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)problem);
        TestDataKitchenSinkSolution solution = (TestDataKitchenSinkSolution)solverJob.getFinalBestSolution();
        Assertions.assertNotNull((Object)solution);
        Assertions.assertEquals((int)1, (Integer)solution.getPlanningEntityProperty().testGetIntVariable());
        Assertions.assertEquals((Object)"A", (Object)solution.getPlanningEntityProperty().testGetStringVariable());
    }
}

