/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.quarkus.testdata.extended.TestdataExtendedQuarkusSolution;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

public class OptaPlannerProcessorExtendedSolutionSolveTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataExtendedQuarkusSolution.class, TestdataQuarkusConstraintProvider.class}));
    @Inject
    SolverFactory<TestdataQuarkusSolution> solverFactory;
    @Inject
    SolverManager<TestdataQuarkusSolution, Long> solverManager;
    @Inject
    ScoreManager<TestdataQuarkusSolution, SimpleScore> scoreManager;

    @Test
    public void singletonSolverFactory() {
        Assertions.assertNotNull(this.solverFactory);
        Assertions.assertNotNull(this.solverManager);
        Assertions.assertSame(this.solverFactory, (Object)((DefaultSolverManager)this.solverManager).getSolverFactory());
        Assertions.assertNotNull(this.scoreManager);
    }

    @Test
    public void solve() throws ExecutionException, InterruptedException {
        TestdataExtendedQuarkusSolution problem = new TestdataExtendedQuarkusSolution("Extra Data");
        problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
        problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataQuarkusEntity()).collect(Collectors.toList()));
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)problem);
        TestdataExtendedQuarkusSolution solution = (TestdataExtendedQuarkusSolution)solverJob.getFinalBestSolution();
        Assertions.assertNotNull((Object)solution);
        Assertions.assertTrue((solution.getScore().getScore() >= 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Extra Data", (Object)solution.getExtraData());
    }
}

