/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.verifier;

import io.quarkus.test.QuarkusUnitTest;
import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultConstraintVerifier;

public class OptaPlannerConstraintVerifierDroolsStreamImplTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class}));
    @Inject
    ConstraintVerifier<TestdataQuarkusConstraintProvider, TestdataQuarkusSolution> constraintVerifier;

    @Test
    public void constraintVerifierDroolsStreamImpl() {
        Assertions.assertEquals((Object)ConstraintStreamImplType.DROOLS, (Object)((DefaultConstraintVerifier)this.constraintVerifier).getConstraintStreamImplType());
        TestdataQuarkusSolution solution = new TestdataQuarkusSolution();
        TestdataQuarkusEntity entityA = new TestdataQuarkusEntity();
        TestdataQuarkusEntity entityB = new TestdataQuarkusEntity();
        entityA.setValue("A");
        entityB.setValue("A");
        solution.setEntityList(Arrays.asList(entityA, entityB));
        solution.setValueList(Arrays.asList("A", "B"));
        this.constraintVerifier.verifyThat().givenSolution((Object)solution).scores((Score)SimpleScore.of((int)-2));
        entityB.setValue("B");
        this.constraintVerifier.verifyThat().givenSolution((Object)solution).scores((Score)SimpleScore.ZERO);
    }
}

