/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.test.QuarkusProdModeTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

class OptaPlannerProcessorOverridePropertiesAtRuntimeTest {
    private static final String QUARKUS_VERSION = OptaPlannerProcessorOverridePropertiesAtRuntimeTest.getRequiredProperty("version.io.quarkus");
    @RegisterExtension
    static final QuarkusProdModeTest config = new QuarkusProdModeTest().setForcedDependencies(List.of(new AppArtifact("io.quarkus", "quarkus-resteasy", QUARKUS_VERSION))).overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").overrideConfigKey("quarkus.optaplanner.solver.move-thread-count", "4").overrideConfigKey("quarkus.optaplanner.solver-manager.parallel-solver-count", "1").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class, OptaPlannerTestResource.class})).setRuntimeProperties(OptaPlannerProcessorOverridePropertiesAtRuntimeTest.getRuntimeProperties()).setRun(true);

    OptaPlannerProcessorOverridePropertiesAtRuntimeTest() {
    }

    private static String getRequiredProperty(String name) {
        String v = System.getProperty(name);
        if (v == null || v.isEmpty()) {
            throw new IllegalStateException("The system property (" + name + ") has not been set.");
        }
        return v;
    }

    private static Map<String, String> getRuntimeProperties() {
        HashMap<String, String> out = new HashMap<String, String>();
        out.put("quarkus.optaplanner.solver.termination.best-score-limit", "7");
        out.put("quarkus.optaplanner.solver.move-thread-count", "3");
        out.put("quarkus.optaplanner.solver-manager.parallel-solver-count", "10");
        return out;
    }

    @Test
    void solverConfigPropertiesShouldBeOverwritten() throws IOException {
        Properties solverConfigProperties = new Properties();
        solverConfigProperties.load(((Response)RestAssured.given().contentType("text/plain").accept("text/plain").when().get("/optaplanner/test/solver-config", new Object[0])).asInputStream());
        Assertions.assertEquals((Object)"7", (Object)solverConfigProperties.get("termination.bestScoreLimit"));
        Assertions.assertEquals((Object)"3", (Object)solverConfigProperties.get("moveThreadCount"));
    }

    @Test
    void solverManagerConfigPropertiesShouldBeOverwritten() throws IOException {
        Properties solverManagerProperties = new Properties();
        solverManagerProperties.load(((Response)RestAssured.given().contentType("text/plain").accept("text/plain").when().get("/optaplanner/test/solver-manager-config", new Object[0])).asInputStream());
        Assertions.assertEquals((Object)"10", (Object)solverManagerProperties.get("parallelSolverCount"));
    }

    @Path(value="/optaplanner/test")
    public static class OptaPlannerTestResource {
        @Inject
        SolverConfig solverConfig;
        @Inject
        SolverManagerConfig solverManagerConfig;

        @GET
        @Path(value="/solver-config")
        @Produces(value={"text/plain"})
        public String getSolverConfig() {
            StringBuilder sb = new StringBuilder();
            sb.append("termination.bestScoreLimit=").append(this.solverConfig.getTerminationConfig().getBestScoreLimit()).append("\n");
            sb.append("moveThreadCount=").append(this.solverConfig.getMoveThreadCount()).append("\n");
            return sb.toString();
        }

        @GET
        @Path(value="/solver-manager-config")
        @Produces(value={"text/plain"})
        public String getSolverManagerConfig() {
            StringBuilder sb = new StringBuilder();
            sb.append("parallelSolverCount=").append(this.solverManagerConfig.getParallelSolverCount()).append("\n");
            return sb.toString();
        }
    }
}

