/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.it.devui;

import groovy.util.Node;
import groovy.xml.XmlParser;
import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.assertj.core.api.Assertions;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.xml.sax.SAXException;

public class OptaPlannerDevUITest {
    @RegisterExtension
    static final QuarkusDevModeTest config = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new String[]{"org.optaplanner.quarkus.it.devui"}));
    static final String OPTAPLANNER_DEV_UI_BASE_URL = System.getProperty("dev.iu.root", "/q/dev-v1") + "/org.optaplanner.optaplanner-quarkus/";

    public static String getPage(String pageName) {
        return OPTAPLANNER_DEV_UI_BASE_URL + pageName;
    }

    @Test
    void testSolverConfigPage() throws ParserConfigurationException, SAXException, IOException {
        String body = ((ValidatableResponse)RestAssured.get((String)OptaPlannerDevUITest.getPage("solverConfig"), (Object[])new Object[0]).then()).extract().body().asPrettyString();
        XmlParser xmlParser = new XmlParser();
        Node node = xmlParser.parseText(body);
        String solverConfig = Objects.requireNonNull(this.findById("optaplanner-solver-config", node)).text();
        Assertions.assertThat((String)solverConfig).isEqualToIgnoringWhitespace((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--Properties that can be set at runtime are not included-->\n<solver>\n  <solutionClass>org.optaplanner.quarkus.it.devui.domain.TestdataStringLengthShadowSolution</solutionClass>\n  <entityClass>org.optaplanner.quarkus.it.devui.domain.TestdataStringLengthShadowEntity</entityClass>\n  <domainAccessType>GIZMO</domainAccessType>\n  <scoreDirectorFactory>\n    <constraintProviderClass>org.optaplanner.quarkus.it.devui.solver.TestdataStringLengthConstraintProvider</constraintProviderClass>\n  </scoreDirectorFactory>\n</solver>");
    }

    @Test
    void testModelPage() throws ParserConfigurationException, SAXException, IOException {
        String body = ((ValidatableResponse)RestAssured.get((String)OptaPlannerDevUITest.getPage("model"), (Object[])new Object[0]).then()).extract().body().asPrettyString();
        XmlParser xmlParser = new XmlParser();
        Node node = xmlParser.parseText(body);
        String model = Objects.requireNonNull(this.findById("optaplanner-model", node)).toString();
        Assertions.assertThat((String)model).contains(new CharSequence[]{"value=[Solution: org.optaplanner.quarkus.it.devui.domain.TestdataStringLengthShadowSolution]"});
        Assertions.assertThat((String)model).contains(new CharSequence[]{"value=[Entity: org.optaplanner.quarkus.it.devui.domain.TestdataStringLengthShadowEntity]"});
        Assertions.assertThat((String)model).contains(new CharSequence[]{"value=[Genuine Variables]]]]]], tbody[attributes={}; value=[tr[attributes={}; value=[td[attributes={colspan=1, rowspan=1}; value=[value]]"});
        Assertions.assertThat((String)model).contains(new CharSequence[]{"value=[Shadow Variables]]]]]], tbody[attributes={}; value=[tr[attributes={}; value=[td[attributes={colspan=1, rowspan=1}; value=[length]]"});
    }

    @Test
    void testConstraintsPage() throws ParserConfigurationException, SAXException, IOException {
        String body = ((ValidatableResponse)RestAssured.get((String)OptaPlannerDevUITest.getPage("constraints"), (Object[])new Object[0]).then()).extract().body().asPrettyString();
        XmlParser xmlParser = new XmlParser();
        Node node = xmlParser.parseText(body);
        String constraints = Objects.requireNonNull(this.findById("optaplanner-constraints", node)).text();
        Assertions.assertThat((String)constraints).contains(new CharSequence[]{"org.optaplanner.quarkus.it.devui.domain/Don't assign 2 entities the same value"});
        Assertions.assertThat((String)constraints).contains(new CharSequence[]{"org.optaplanner.quarkus.it.devui.domain/Maximize value length"});
    }

    private Node findById(String id, Node node) {
        if (id.equals(node.attribute((Object)"id"))) {
            return node;
        }
        for (Object child : node.children()) {
            Node maybeFoundNodeText;
            if (!(child instanceof Node) || (maybeFoundNodeText = this.findById(id, (Node)child)) == null) continue;
            return maybeFoundNodeText;
        }
        return null;
    }
}

