/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.drl.it;

import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.quarkus.drl.it.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.drl.it.domain.TestdataQuarkusSolution;

@Path(value="/optaplanner/test")
public class OptaPlannerTestResource {
    @Inject
    SolverManager<TestdataQuarkusSolution, Long> solverManager;

    @POST
    @Path(value="/solver-factory")
    @Produces(value={"text/plain"})
    public String solveWithSolverFactory() throws InterruptedException {
        TestdataQuarkusSolution planningProblem = new TestdataQuarkusSolution();
        planningProblem.setEntityList(Arrays.asList(new TestdataQuarkusEntity(), new TestdataQuarkusEntity()));
        planningProblem.setLeftValueList(Arrays.asList("a", "b", "c"));
        planningProblem.setRightValueList(Arrays.asList("1", "2", "3"));
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)planningProblem);
        try {
            TestdataQuarkusSolution sol = (TestdataQuarkusSolution)solverJob.getFinalBestSolution();
            StringBuilder out = new StringBuilder();
            out.append("score=").append(sol.getScore()).append('\n');
            for (int i = 0; i < sol.getEntityList().size(); ++i) {
                out.append("entity." + i + ".fullValue=").append(sol.getEntityList().get(i).getFullValue()).append('\n');
            }
            return out.toString();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Solving failed.", e);
        }
    }
}

