/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.it.reflection;

import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.quarkus.it.reflection.domain.TestdataReflectionEntity;
import org.optaplanner.quarkus.it.reflection.domain.TestdataReflectionSolution;

@Path(value="/optaplanner/test")
public class OptaPlannerTestResource {
    @Inject
    SolverManager<TestdataReflectionSolution, Long> solverManager;

    @POST
    @Path(value="/solver-factory")
    @Produces(value={"text/plain"})
    public String solveWithSolverFactory() {
        TestdataReflectionSolution planningProblem = new TestdataReflectionSolution();
        planningProblem.setEntityList(Arrays.asList(new TestdataReflectionEntity(), new TestdataReflectionEntity()));
        planningProblem.setFieldValueList(Arrays.asList("a", "bb", "ccc"));
        planningProblem.setMethodValueList(Arrays.asList("a", "bb", "ccc", "ddd"));
        SolverJob solverJob = this.solverManager.solve((Object)1L, (Object)planningProblem);
        try {
            return ((TestdataReflectionSolution)solverJob.getFinalBestSolution()).getScore().toString();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Solving was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Solving failed.", e);
        }
    }
}

