/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import com.fasterxml.jackson.databind.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.persistence.jackson.api.OptaPlannerJacksonModule;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerProperties;
import org.optaplanner.spring.boot.autoconfigure.SolverManagerProperties;
import org.optaplanner.spring.boot.autoconfigure.SolverProperties;
import org.optaplanner.spring.boot.autoconfigure.TerminationProperties;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScanner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={SolverConfig.class, SolverFactory.class, ScoreManager.class, SolverManager.class})
@ConditionalOnMissingBean(value={SolverConfig.class, SolverFactory.class, ScoreManager.class, SolverManager.class})
@EnableConfigurationProperties(value={OptaPlannerProperties.class})
public class OptaPlannerAutoConfiguration
implements BeanClassLoaderAware {
    private final ApplicationContext context;
    private final OptaPlannerProperties optaPlannerProperties;
    private ClassLoader beanClassLoader;

    protected OptaPlannerAutoConfiguration(ApplicationContext context, OptaPlannerProperties optaPlannerProperties) {
        this.context = context;
        this.optaPlannerProperties = optaPlannerProperties;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean
    @ConditionalOnMissingBean
    public <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> solverManager(SolverFactory solverFactory) {
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        SolverManagerProperties solverManagerProperties = this.optaPlannerProperties.getSolverManager();
        if (solverManagerProperties != null && solverManagerProperties.getParallelSolverCount() != null) {
            solverManagerConfig.setParallelSolverCount(solverManagerProperties.getParallelSolverCount());
        }
        return SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)solverManagerConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public <Solution_> ScoreManager<Solution_> scoreManager(SolverFactory solverFactory) {
        return ScoreManager.create((SolverFactory)solverFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public <Solution_> SolverFactory<Solution_> solverFactory(SolverConfig solverConfig) {
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public SolverConfig solverConfig() {
        SolverConfig solverConfig;
        String solverConfigXml = this.optaPlannerProperties.getSolverConfigXml();
        if (solverConfigXml != null) {
            if (this.beanClassLoader.getResource(solverConfigXml) == null) {
                throw new IllegalStateException("Invalid optaplanner.solverConfigXml property (" + solverConfigXml + "): that classpath resource does not exist.");
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverConfigXml, (ClassLoader)this.beanClassLoader);
        } else {
            solverConfig = this.beanClassLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml", (ClassLoader)this.beanClassLoader) : new SolverConfig(this.beanClassLoader);
        }
        this.applySolverProperties(solverConfig);
        return solverConfig;
    }

    private void applySolverProperties(SolverConfig solverConfig) {
        SolverProperties solverProperties;
        EntityScanner entityScanner = new EntityScanner(this.context);
        if (solverConfig.getScanAnnotatedClassesConfig() != null) {
            throw new IllegalArgumentException("Do not use scanAnnotatedClasses with the Spring Boot starter, because the Spring Boot starter scans too.\nMaybe delete the scanAnnotatedClasses element in the solver config.");
        }
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findSolutionClass(entityScanner));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(entityScanner));
        }
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findImplementingClass(EasyScoreCalculator.class));
            scoreDirectorFactoryConfig.setConstraintProviderClass(this.findImplementingClass(ConstraintProvider.class));
            scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findImplementingClass(IncrementalScoreCalculator.class));
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        }
        if ((solverProperties = this.optaPlannerProperties.getSolver()) != null) {
            if (solverProperties.getEnvironmentMode() != null) {
                solverConfig.setEnvironmentMode(solverProperties.getEnvironmentMode());
            }
            if (solverProperties.getMoveThreadCount() != null) {
                solverConfig.setMoveThreadCount(solverProperties.getMoveThreadCount());
            }
            this.applyTerminationProperties(solverConfig, solverProperties);
        }
    }

    private Class<?> findSolutionClass(EntityScanner entityScanner) {
        Set solutionClassSet;
        try {
            solutionClassSet = entityScanner.scan(new Class[]{PlanningSolution.class});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @" + PlanningSolution.class.getSimpleName() + " annotations failed.", e);
        }
        if (solutionClassSet.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + solutionClassSet + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (solutionClassSet.isEmpty()) {
            throw new IllegalStateException("No classes (" + solutionClassSet + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        return (Class)solutionClassSet.iterator().next();
    }

    private List<Class<?>> findEntityClassList(EntityScanner entityScanner) {
        Set entityClassSet;
        try {
            entityClassSet = entityScanner.scan(new Class[]{PlanningEntity.class});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @" + PlanningEntity.class.getSimpleName() + " failed.", e);
        }
        if (entityClassSet.isEmpty()) {
            throw new IllegalStateException("No classes (" + entityClassSet + ") found with a @" + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        return new ArrayList(entityClassSet);
    }

    private <T> Class<? extends T> findImplementingClass(Class<T> targetClass) {
        if (!AutoConfigurationPackages.has((BeanFactory)this.context)) {
            return null;
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.context.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.context);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(targetClass));
        List packages = AutoConfigurationPackages.get((BeanFactory)this.context);
        List classList = packages.stream().flatMap(basePackage -> scanner.findCandidateComponents(basePackage).stream()).map(candidate -> {
            try {
                Class clazz = ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.context.getClassLoader()).asSubclass(targetClass);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The " + targetClass.getSimpleName() + " class (" + candidate.getBeanClassName() + ") cannot be found.", e);
            }
        }).collect(Collectors.toList());
        if (classList.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + classList + ") found that implement " + targetClass.getSimpleName() + ".");
        }
        if (classList.isEmpty()) {
            return null;
        }
        return (Class)classList.get(0);
    }

    private void applyTerminationProperties(SolverConfig solverConfig, SolverProperties solverProperties) {
        TerminationProperties terminationProperties;
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        if ((terminationProperties = solverProperties.getTermination()) != null) {
            if (terminationProperties.getSpentLimit() != null) {
                terminationConfig.overwriteSpentLimit(terminationProperties.getSpentLimit());
            }
            if (terminationProperties.getUnimprovedSpentLimit() != null) {
                terminationConfig.overwriteUnimprovedSpentLimit(terminationProperties.getUnimprovedSpentLimit());
            }
            if (terminationProperties.getBestScoreLimit() != null) {
                terminationConfig.setBestScoreLimit(terminationProperties.getBestScoreLimit());
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class, Score.class})
    static class OptaPlannerJacksonConfiguration {
        OptaPlannerJacksonConfiguration() {
        }

        @Bean
        Module jacksonModule() {
            return OptaPlannerJacksonModule.createModule();
        }
    }
}

