/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import java.time.Duration;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerAutoConfiguration;
import org.optaplanner.spring.boot.autoconfigure.solver.TestdataSpringConstraintProvider;
import org.optaplanner.spring.boot.autoconfigure.testdata.TestdataSpringEntity;
import org.optaplanner.spring.boot.autoconfigure.testdata.TestdataSpringSolution;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

public class OptaPlannerAutoConfigurationTest {
    private final ApplicationContextRunner contextRunner = (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{OptaPlannerAutoConfiguration.class}))).withUserConfiguration(new Class[]{TestConfiguration.class});

    @Test
    public void solverConfigXml_none() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new ClassPathResource[]{new ClassPathResource("solverConfig.xml")}))).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assert.assertNotNull((Object)solverConfig);
            Assert.assertEquals(TestdataSpringSolution.class, (Object)solverConfig.getSolutionClass());
            Assert.assertEquals(Collections.singletonList(TestdataSpringEntity.class), (Object)solverConfig.getEntityClassList());
            Assert.assertEquals(TestdataSpringConstraintProvider.class, (Object)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass());
            Assert.assertNull((Object)solverConfig.getTerminationConfig());
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assert.assertNotNull((Object)solverFactory);
            Assert.assertNotNull((Object)solverFactory.buildSolver());
        });
    }

    @Test
    public void solverConfigXml_default() {
        this.contextRunner.run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assert.assertNotNull((Object)solverConfig);
            Assert.assertEquals(TestdataSpringSolution.class, (Object)solverConfig.getSolutionClass());
            Assert.assertEquals(Collections.singletonList(TestdataSpringEntity.class), (Object)solverConfig.getEntityClassList());
            Assert.assertEquals(TestdataSpringConstraintProvider.class, (Object)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass());
            Assert.assertEquals((long)2L, (long)solverConfig.getTerminationConfig().getSecondsSpentLimit());
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assert.assertNotNull((Object)solverFactory);
            Assert.assertNotNull((Object)solverFactory.buildSolver());
        });
    }

    @Test
    public void solverConfigXml_property() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/customSpringBootSolverConfig.xml"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assert.assertNotNull((Object)solverConfig);
            Assert.assertEquals(TestdataSpringSolution.class, (Object)solverConfig.getSolutionClass());
            Assert.assertEquals(Collections.singletonList(TestdataSpringEntity.class), (Object)solverConfig.getEntityClassList());
            Assert.assertEquals(TestdataSpringConstraintProvider.class, (Object)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass());
            Assert.assertEquals((long)3L, (long)solverConfig.getTerminationConfig().getMinutesSpentLimit());
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assert.assertNotNull((Object)solverFactory);
            Assert.assertNotNull((Object)solverFactory.buildSolver());
        });
    }

    @Test
    public void scanAnnotatedClasses() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> {
            ApplicationContextRunner cfr_ignored_0 = (ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/illegalScanAnnotatedSpringBootSolverConfig.xml"})).run(context -> {
                SolverConfig cfr_ignored_0 = (SolverConfig)context.getBean(SolverConfig.class);
            });
        });
    }

    @Test
    public void solverProperties() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.environment-mode=FULL_ASSERT"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assert.assertEquals((Object)EnvironmentMode.FULL_ASSERT, (Object)solverConfig.getEnvironmentMode());
            Assert.assertNotNull((Object)context.getBean(SolverFactory.class));
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.daemon=true"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assert.assertTrue((boolean)solverConfig.getDaemon());
            Assert.assertNotNull((Object)context.getBean(SolverFactory.class));
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.move-thread-count=2"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assert.assertEquals((Object)"2", (Object)solverConfig.getMoveThreadCount());
            Assert.assertNotNull((Object)context.getBean(SolverFactory.class));
        });
    }

    @Test
    public void terminationProperties() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.termination.spent-limit=4h"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assert.assertEquals((Object)Duration.ofHours(4L), (Object)terminationConfig.getSpentLimit());
            Assert.assertNotNull((Object)context.getBean(SolverFactory.class));
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.termination.unimproved-spent-limit=5h"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assert.assertEquals((Object)Duration.ofHours(5L), (Object)terminationConfig.getUnimprovedSpentLimit());
            Assert.assertNotNull((Object)context.getBean(SolverFactory.class));
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.termination.best-score-limit=6"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assert.assertEquals((Object)SimpleScore.of((int)6).toString(), (Object)terminationConfig.getBestScoreLimit());
            Assert.assertNotNull((Object)context.getBean(SolverFactory.class));
        });
    }

    @Test
    public void singletonSolverFactory() {
        this.contextRunner.run(context -> {
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assert.assertNotNull((Object)solverFactory);
            ScoreManager scoreManager = (ScoreManager)context.getBean(ScoreManager.class);
            Assert.assertNotNull((Object)scoreManager);
            SolverManager solverManager = (SolverManager)context.getBean(SolverManager.class);
            Assert.assertNotNull((Object)solverManager);
            Assert.assertSame((Object)solverFactory, (Object)((DefaultSolverManager)solverManager).getSolverFactory());
        });
    }

    @Test
    public void solve() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new ClassPathResource[]{new ClassPathResource("solverConfig.xml")}))).withPropertyValues(new String[]{"optaplanner.solver.termination.best-score-limit=0"})).run(context -> {
            SolverManager solverManager = (SolverManager)context.getBean(SolverManager.class);
            TestdataSpringSolution problem = new TestdataSpringSolution();
            problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
            problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataSpringEntity()).collect(Collectors.toList()));
            SolverJob solverJob = solverManager.solve((Object)1L, (Object)problem);
            TestdataSpringSolution solution = (TestdataSpringSolution)solverJob.getFinalBestSolution();
            Assert.assertNotNull((Object)solution);
            Assert.assertTrue((solution.getScore().getScore() >= 0 ? 1 : 0) != 0);
        });
    }

    @Configuration
    @EntityScan(basePackageClasses={TestdataSpringSolution.class, TestdataSpringConstraintProvider.class})
    @AutoConfigurationPackage
    public static class TestConfiguration {
    }
}

