/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerAutoConfiguration;
import org.optaplanner.spring.boot.autoconfigure.solver.TestdataSpringConstraintProvider;
import org.optaplanner.spring.boot.autoconfigure.testdata.TestdataSpringEntity;
import org.optaplanner.spring.boot.autoconfigure.testdata.TestdataSpringSolution;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

public class OptaPlannerAutoConfigurationTest {
    private final ApplicationContextRunner contextRunner = (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{OptaPlannerAutoConfiguration.class}))).withUserConfiguration(new Class[]{TestConfiguration.class});

    @Test
    public void solverConfigXml_none() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new ClassPathResource[]{new ClassPathResource("solverConfig.xml")}))).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).isEqualTo(Collections.singletonList(TestdataSpringEntity.class));
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataSpringConstraintProvider.class);
            Assertions.assertThat((Object)solverConfig.getTerminationConfig()).isNull();
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    public void solverConfigXml_default() {
        this.contextRunner.run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).isEqualTo(Collections.singletonList(TestdataSpringEntity.class));
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataSpringConstraintProvider.class);
            Assertions.assertThat((long)solverConfig.getTerminationConfig().getSecondsSpentLimit()).isEqualTo(2L);
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    public void solverConfigXml_property() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/customSpringBootSolverConfig.xml"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).isEqualTo(Collections.singletonList(TestdataSpringEntity.class));
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataSpringConstraintProvider.class);
            Assertions.assertThat((long)solverConfig.getTerminationConfig().getMinutesSpentLimit()).isEqualTo(3L);
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    public void scanAnnotatedClasses() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> {
            ApplicationContextRunner cfr_ignored_0 = (ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/illegalScanAnnotatedSpringBootSolverConfig.xml"})).run(context -> {
                SolverConfig cfr_ignored_0 = (SolverConfig)context.getBean(SolverConfig.class);
            });
        });
    }

    @Test
    public void solverProperties() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.environment-mode=FULL_ASSERT"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Comparable)solverConfig.getEnvironmentMode()).isEqualTo((Object)EnvironmentMode.FULL_ASSERT);
            Assertions.assertThat((Object)context.getBean(SolverFactory.class)).isNotNull();
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.daemon=true"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Boolean)solverConfig.getDaemon()).isTrue();
            Assertions.assertThat((Object)context.getBean(SolverFactory.class)).isNotNull();
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.move-thread-count=2"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((String)solverConfig.getMoveThreadCount()).isEqualTo("2");
            Assertions.assertThat((Object)context.getBean(SolverFactory.class)).isNotNull();
        });
    }

    @Test
    public void terminationProperties() {
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.termination.spent-limit=4h"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assertions.assertThat((Comparable)terminationConfig.getSpentLimit()).isEqualTo((Object)Duration.ofHours(4L));
            Assertions.assertThat((Object)context.getBean(SolverFactory.class)).isNotNull();
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.termination.unimproved-spent-limit=5h"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assertions.assertThat((Comparable)terminationConfig.getUnimprovedSpentLimit()).isEqualTo((Object)Duration.ofHours(5L));
            Assertions.assertThat((Object)context.getBean(SolverFactory.class)).isNotNull();
        });
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.solver.termination.best-score-limit=6"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assertions.assertThat((String)terminationConfig.getBestScoreLimit()).isEqualTo(SimpleScore.of((int)6).toString());
            Assertions.assertThat((Object)context.getBean(SolverFactory.class)).isNotNull();
        });
    }

    @Test
    public void singletonSolverFactory() {
        this.contextRunner.run(context -> {
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            ScoreManager scoreManager = (ScoreManager)context.getBean(ScoreManager.class);
            Assertions.assertThat((Object)scoreManager).isNotNull();
            SolverManager solverManager = (SolverManager)context.getBean(SolverManager.class);
            Assertions.assertThat((Object)solverManager).isNotNull();
            Assertions.assertThat((Object)((DefaultSolverManager)solverManager).getSolverFactory()).isSameAs((Object)solverFactory);
        });
    }

    @Test
    public void solve() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)new FilteredClassLoader(new ClassPathResource[]{new ClassPathResource("solverConfig.xml")}))).withPropertyValues(new String[]{"optaplanner.solver.termination.best-score-limit=0"})).run(context -> {
            SolverManager solverManager = (SolverManager)context.getBean(SolverManager.class);
            TestdataSpringSolution problem = new TestdataSpringSolution();
            problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
            problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataSpringEntity()).collect(Collectors.toList()));
            SolverJob solverJob = solverManager.solve((Object)1L, (Object)problem);
            TestdataSpringSolution solution = (TestdataSpringSolution)solverJob.getFinalBestSolution();
            Assertions.assertThat((Object)solution).isNotNull();
            Assertions.assertThat((int)solution.getScore().getScore()).isGreaterThanOrEqualTo(0);
        });
    }

    @Configuration
    @EntityScan(basePackageClasses={TestdataSpringSolution.class, TestdataSpringConstraintProvider.class})
    @AutoConfigurationPackage
    public static class TestConfiguration {
    }
}

