/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import java.io.File;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerAutoConfiguration;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerProperties;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OptaPlannerAutoConfiguration.class})
@ConditionalOnClass(value={PlannerBenchmarkFactory.class})
@ConditionalOnMissingBean(value={PlannerBenchmarkFactory.class})
@EnableConfigurationProperties(value={OptaPlannerProperties.class})
public class OptaPlannerBenchmarkAutoConfiguration
implements BeanClassLoaderAware {
    private final ApplicationContext context;
    private final OptaPlannerProperties optaPlannerProperties;
    private ClassLoader beanClassLoader;

    protected OptaPlannerBenchmarkAutoConfiguration(ApplicationContext context, OptaPlannerProperties optaPlannerProperties) {
        this.context = context;
        this.optaPlannerProperties = optaPlannerProperties;
    }

    @Bean
    public PlannerBenchmarkConfig plannerBenchmarkConfig(SolverConfig solverConfig) {
        PlannerBenchmarkConfig benchmarkConfig;
        if (this.optaPlannerProperties.getBenchmark() != null && this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml() != null) {
            if (this.beanClassLoader.getResource(this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml()) == null) {
                throw new IllegalStateException("Invalid optaplanner.benchmark.solverBenchmarkConfigXml property (" + this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml() + "): that classpath resource does not exist.");
            }
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml(), (ClassLoader)this.beanClassLoader);
        } else if (this.beanClassLoader.getResource("solverBenchmarkConfig.xml") != null) {
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"solverConfig.xml", (ClassLoader)this.beanClassLoader);
        } else {
            benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig);
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.optaPlannerProperties.getBenchmark() != null && this.optaPlannerProperties.getBenchmark().getResultDirectory() != null) {
            benchmarkConfig.setBenchmarkDirectory(new File(this.optaPlannerProperties.getBenchmark().getResultDirectory()));
        }
        if (benchmarkConfig.getBenchmarkDirectory() == null) {
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.optaPlannerProperties.getBenchmark() != null && this.optaPlannerProperties.getBenchmark().getSolver() != null) {
            OptaPlannerAutoConfiguration.applyTerminationProperties(benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig(), this.optaPlannerProperties.getBenchmark().getSolver().getTermination());
        }
        if (!this.isTerminationConfigured(benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig())) {
            throw new IllegalStateException("Property optaplanner.benchmark.solver.termination.spentLimit is required if termination is not configured.");
        }
        return benchmarkConfig;
    }

    @Bean
    public PlannerBenchmarkFactory plannerBenchmarkFactory(PlannerBenchmarkConfig benchmarkConfig) {
        return PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private boolean isTerminationConfigured(TerminationConfig terminationConfig) {
        return terminationConfig.getTerminationClass() != null || terminationConfig.getSpentLimit() != null || terminationConfig.getBestScoreLimit() != null || terminationConfig.getUnimprovedSpentLimit() != null || terminationConfig.getStepCountLimit() != null || terminationConfig.getTerminationConfigList() != null;
    }
}

