/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerAutoConfiguration;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerProperties;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OptaPlannerAutoConfiguration.class})
@ConditionalOnClass(value={PlannerBenchmarkFactory.class})
@ConditionalOnMissingBean(value={PlannerBenchmarkFactory.class})
@EnableConfigurationProperties(value={OptaPlannerProperties.class})
public class OptaPlannerBenchmarkAutoConfiguration
implements BeanClassLoaderAware {
    private final ApplicationContext context;
    private final OptaPlannerProperties optaPlannerProperties;
    private ClassLoader beanClassLoader;

    protected OptaPlannerBenchmarkAutoConfiguration(ApplicationContext context, OptaPlannerProperties optaPlannerProperties) {
        this.context = context;
        this.optaPlannerProperties = optaPlannerProperties;
    }

    @Bean
    public PlannerBenchmarkConfig plannerBenchmarkConfig(SolverConfig solverConfig) {
        PlannerBenchmarkConfig benchmarkConfig;
        if (this.optaPlannerProperties.getBenchmark() != null && this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml() != null) {
            if (this.beanClassLoader.getResource(this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml()) == null) {
                throw new IllegalStateException("Invalid optaplanner.benchmark.solverBenchmarkConfigXml property (" + this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml() + "): that classpath resource does not exist.");
            }
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)this.optaPlannerProperties.getBenchmark().getSolverBenchmarkConfigXml(), (ClassLoader)this.beanClassLoader);
        } else if (this.beanClassLoader.getResource("solverBenchmarkConfig.xml") != null) {
            benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)"solverBenchmarkConfig.xml", (ClassLoader)this.beanClassLoader);
        } else {
            benchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig);
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.optaPlannerProperties.getBenchmark() != null && this.optaPlannerProperties.getBenchmark().getResultDirectory() != null) {
            benchmarkConfig.setBenchmarkDirectory(new File(this.optaPlannerProperties.getBenchmark().getResultDirectory()));
        }
        if (benchmarkConfig.getBenchmarkDirectory() == null) {
            benchmarkConfig.setBenchmarkDirectory(new File("target/benchmarks"));
        }
        if (this.optaPlannerProperties.getBenchmark() != null && this.optaPlannerProperties.getBenchmark().getSolver() != null) {
            OptaPlannerAutoConfiguration.applyTerminationProperties(benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig(), this.optaPlannerProperties.getBenchmark().getSolver().getTermination());
        }
        if (benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig() == null || !benchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig().isConfigured()) {
            List solverBenchmarkConfigList = benchmarkConfig.getSolverBenchmarkConfigList();
            ArrayList<String> unconfiguredTerminationSolverBenchmarkList = new ArrayList<String>();
            if (solverBenchmarkConfigList == null) {
                throw new IllegalStateException("At least one of the properties optaplanner.benchmark.solver.termination.spent-limit, optaplanner.benchmark.solver.termination.best-score-limit, optaplanner.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in the inherited solver benchmark config and solverBenchmarkBluePrint is used.");
            }
            for (int i = 0; i < solverBenchmarkConfigList.size(); ++i) {
                SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)solverBenchmarkConfigList.get(i);
                TerminationConfig terminationConfig = solverBenchmarkConfig.getSolverConfig().getTerminationConfig();
                if (terminationConfig != null && terminationConfig.isConfigured()) continue;
                boolean isTerminationConfiguredForAllNonConstructionHeuristicPhases = !solverBenchmarkConfig.getSolverConfig().getPhaseConfigList().isEmpty();
                for (PhaseConfig phaseConfig : solverBenchmarkConfig.getSolverConfig().getPhaseConfigList()) {
                    if (phaseConfig instanceof ConstructionHeuristicPhaseConfig || phaseConfig.getTerminationConfig() != null && phaseConfig.getTerminationConfig().isConfigured()) continue;
                    isTerminationConfiguredForAllNonConstructionHeuristicPhases = false;
                    break;
                }
                if (isTerminationConfiguredForAllNonConstructionHeuristicPhases) continue;
                Object benchmarkConfigName = solverBenchmarkConfig.getName();
                if (benchmarkConfigName == null) {
                    benchmarkConfigName = "SolverBenchmarkConfig " + i;
                }
                unconfiguredTerminationSolverBenchmarkList.add((String)benchmarkConfigName);
            }
            if (!unconfiguredTerminationSolverBenchmarkList.isEmpty()) {
                throw new IllegalStateException("The following " + SolverBenchmarkConfig.class.getSimpleName() + " do not have termination configured: " + unconfiguredTerminationSolverBenchmarkList.stream().collect(Collectors.joining(", ", "[", "]")) + ". At least one of the properties optaplanner.benchmark.solver.termination.spent-limit, optaplanner.benchmark.solver.termination.best-score-limit, optaplanner.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in a solver benchmark and the inherited solver benchmark config.");
            }
        }
        return benchmarkConfig;
    }

    @Bean
    public PlannerBenchmarkFactory plannerBenchmarkFactory(PlannerBenchmarkConfig benchmarkConfig) {
        return PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

