/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import com.fasterxml.jackson.databind.Module;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.persistence.jackson.api.OptaPlannerJacksonModule;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerProperties;
import org.optaplanner.spring.boot.autoconfigure.SolverManagerProperties;
import org.optaplanner.spring.boot.autoconfigure.SolverProperties;
import org.optaplanner.spring.boot.autoconfigure.TerminationProperties;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SolverConfig.class, SolverFactory.class, ScoreManager.class, SolverManager.class})
@ConditionalOnMissingBean(value={SolverConfig.class, SolverFactory.class, ScoreManager.class, SolverManager.class})
@EnableConfigurationProperties(value={OptaPlannerProperties.class})
public class OptaPlannerAutoConfiguration
implements BeanClassLoaderAware {
    private final ApplicationContext context;
    private final OptaPlannerProperties optaPlannerProperties;
    private ClassLoader beanClassLoader;

    protected OptaPlannerAutoConfiguration(ApplicationContext context, OptaPlannerProperties optaPlannerProperties) {
        this.context = context;
        this.optaPlannerProperties = optaPlannerProperties;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean
    @ConditionalOnMissingBean
    public <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> solverManager(SolverFactory solverFactory) {
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        SolverManagerProperties solverManagerProperties = this.optaPlannerProperties.getSolverManager();
        if (solverManagerProperties != null && solverManagerProperties.getParallelSolverCount() != null) {
            solverManagerConfig.setParallelSolverCount(solverManagerProperties.getParallelSolverCount());
        }
        return SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)solverManagerConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public <Solution_, Score_ extends Score<Score_>> ScoreManager<Solution_, Score_> scoreManager(SolverFactory solverFactory) {
        return ScoreManager.create((SolverFactory)solverFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public <Solution_> SolverFactory<Solution_> solverFactory(SolverConfig solverConfig) {
        return SolverFactory.create((SolverConfig)solverConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    public SolverConfig solverConfig() {
        SolverConfig solverConfig;
        String solverConfigXml = this.optaPlannerProperties.getSolverConfigXml();
        if (solverConfigXml != null) {
            if (this.beanClassLoader.getResource(solverConfigXml) == null) {
                throw new IllegalStateException("Invalid optaplanner.solverConfigXml property (" + solverConfigXml + "): that classpath resource does not exist.");
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverConfigXml, (ClassLoader)this.beanClassLoader);
        } else {
            solverConfig = this.beanClassLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml", (ClassLoader)this.beanClassLoader) : new SolverConfig(this.beanClassLoader);
        }
        this.applySolverProperties(solverConfig);
        return solverConfig;
    }

    private void applySolverProperties(SolverConfig solverConfig) {
        WorkaroundEntityScanner entityScanner = new WorkaroundEntityScanner(this.context);
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findSolutionClass(entityScanner));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(entityScanner));
        }
        this.applyScoreDirectorFactoryProperties(solverConfig);
        SolverProperties solverProperties = this.optaPlannerProperties.getSolver();
        if (solverProperties != null) {
            if (solverProperties.getEnvironmentMode() != null) {
                solverConfig.setEnvironmentMode(solverProperties.getEnvironmentMode());
            }
            if (solverProperties.getDomainAccessType() != null) {
                solverConfig.setDomainAccessType(solverProperties.getDomainAccessType());
            }
            if (solverProperties.getDaemon() != null) {
                solverConfig.setDaemon(solverProperties.getDaemon());
            }
            if (solverProperties.getMoveThreadCount() != null) {
                solverConfig.setMoveThreadCount(solverProperties.getMoveThreadCount());
            }
            this.applyTerminationProperties(solverConfig, solverProperties);
        }
    }

    private Class<?> findSolutionClass(WorkaroundEntityScanner entityScanner) {
        Set<Class<?>> solutionClassSet;
        try {
            solutionClassSet = entityScanner.scan(PlanningSolution.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @" + PlanningSolution.class.getSimpleName() + " annotations failed.", e);
        }
        if (solutionClassSet.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + solutionClassSet + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (solutionClassSet.isEmpty()) {
            throw new IllegalStateException("No classes (" + solutionClassSet + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.\nMaybe your @" + PlanningSolution.class.getSimpleName() + " annotated class  is not in a subpackage of your @" + SpringBootApplication.class.getSimpleName() + " annotated class's package.\nMaybe move your planning solution class to your application class's (sub)package (or use @" + EntityScan.class.getSimpleName() + ").");
        }
        return solutionClassSet.iterator().next();
    }

    private List<Class<?>> findEntityClassList(WorkaroundEntityScanner entityScanner) {
        Set<Class<?>> entityClassSet;
        try {
            entityClassSet = entityScanner.scan(PlanningEntity.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Scanning for @" + PlanningEntity.class.getSimpleName() + " failed.", e);
        }
        if (entityClassSet.isEmpty()) {
            throw new IllegalStateException("No classes (" + entityClassSet + ") found with a @" + PlanningEntity.class.getSimpleName() + " annotation.\nMaybe your @" + PlanningEntity.class.getSimpleName() + " annotated class(es)  are not in a subpackage of your @" + SpringBootApplication.class.getSimpleName() + " annotated class's package.\nMaybe move your planning entity classes to your application class's (sub)package (or use @" + EntityScan.class.getSimpleName() + ").");
        }
        return new ArrayList(entityClassSet);
    }

    protected void applyScoreDirectorFactoryProperties(SolverConfig solverConfig) {
        String effectiveConstraintsDrl;
        String constraintsDrlFromProperty = this.constraintsDrl();
        String defaultConstraintsDrl = this.defaultConstraintsDrl();
        String string = effectiveConstraintsDrl = constraintsDrlFromProperty != null ? constraintsDrlFromProperty : defaultConstraintsDrl;
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            solverConfig.setScoreDirectorFactoryConfig(this.defaultScoreDirectoryFactoryConfig(effectiveConstraintsDrl));
        } else {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
            if (constraintsDrlFromProperty != null) {
                scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(constraintsDrlFromProperty));
            } else if (scoreDirectorFactoryConfig.getScoreDrlList() == null && defaultConstraintsDrl != null) {
                scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(defaultConstraintsDrl));
            }
        }
    }

    protected String constraintsDrl() {
        String constraintsDrl = this.optaPlannerProperties.getScoreDrl();
        if (constraintsDrl != null && this.beanClassLoader.getResource(constraintsDrl) == null) {
            throw new IllegalStateException("Invalid optaplanner.score-drl property (" + constraintsDrl + "): that classpath resource does not exist.");
        }
        return constraintsDrl;
    }

    protected String defaultConstraintsDrl() {
        return this.beanClassLoader.getResource("constraints.drl") != null ? "constraints.drl" : null;
    }

    private ScoreDirectorFactoryConfig defaultScoreDirectoryFactoryConfig(String constraintsDrl) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findImplementingClass(EasyScoreCalculator.class));
        scoreDirectorFactoryConfig.setConstraintProviderClass(this.findImplementingClass(ConstraintProvider.class));
        scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findImplementingClass(IncrementalScoreCalculator.class));
        if (constraintsDrl != null) {
            scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(constraintsDrl));
        }
        if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getConstraintProviderClass() == null && scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getScoreDrlList() == null) {
            throw new IllegalStateException("No classes found that implement " + EasyScoreCalculator.class.getSimpleName() + ", " + ConstraintProvider.class.getSimpleName() + " or " + IncrementalScoreCalculator.class.getSimpleName() + ".\nNeither was a property " + "optaplanner.score-drl" + " defined, nor a " + "constraints.drl" + " resource found.\nMaybe your " + ConstraintProvider.class.getSimpleName() + " class  is not in a subpackage of your @" + SpringBootApplication.class.getSimpleName() + " annotated class's package.\nMaybe move your constraint provider class to your application class's (sub)package.");
        }
        return scoreDirectorFactoryConfig;
    }

    private <T> Class<? extends T> findImplementingClass(Class<T> targetClass) {
        if (!AutoConfigurationPackages.has((BeanFactory)this.context)) {
            return null;
        }
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.context.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.context);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(targetClass));
        List packages = AutoConfigurationPackages.get((BeanFactory)this.context);
        List classList = packages.stream().flatMap(basePackage -> scanner.findCandidateComponents(basePackage).stream()).map(candidate -> {
            try {
                Class clazz = ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.context.getClassLoader()).asSubclass(targetClass);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The " + targetClass.getSimpleName() + " class (" + candidate.getBeanClassName() + ") cannot be found.", e);
            }
        }).collect(Collectors.toList());
        if (classList.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + classList + ") found that implement the interface " + targetClass.getSimpleName() + ".");
        }
        if (classList.isEmpty()) {
            return null;
        }
        return (Class)classList.get(0);
    }

    private void applyTerminationProperties(SolverConfig solverConfig, SolverProperties solverProperties) {
        TerminationProperties terminationProperties;
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        if ((terminationProperties = solverProperties.getTermination()) != null) {
            if (terminationProperties.getSpentLimit() != null) {
                terminationConfig.overwriteSpentLimit(terminationProperties.getSpentLimit());
            }
            if (terminationProperties.getUnimprovedSpentLimit() != null) {
                terminationConfig.overwriteUnimprovedSpentLimit(terminationProperties.getUnimprovedSpentLimit());
            }
            if (terminationProperties.getBestScoreLimit() != null) {
                terminationConfig.setBestScoreLimit(terminationProperties.getBestScoreLimit());
            }
        }
    }

    private static class WorkaroundEntityScanner {
        private final ApplicationContext context;

        public WorkaroundEntityScanner(ApplicationContext context) {
            Assert.notNull((Object)context, (String)"Context must not be null");
            this.context = context;
        }

        @SafeVarargs
        public final Set<Class<?>> scan(Class<? extends Annotation> ... annotationTypes) throws ClassNotFoundException {
            List<String> packages = this.getPackages();
            if (packages.isEmpty()) {
                return Collections.emptySet();
            }
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

                protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                    AnnotationMetadata metadata = beanDefinition.getMetadata();
                    return metadata.isIndependent();
                }
            };
            scanner.setEnvironment(this.context.getEnvironment());
            scanner.setResourceLoader((ResourceLoader)this.context);
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
            }
            HashSet entitySet = new HashSet();
            for (String basePackage : packages) {
                if (!StringUtils.hasText((String)basePackage)) continue;
                for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                    entitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.context.getClassLoader()));
                }
            }
            return entitySet;
        }

        private List<String> getPackages() {
            List packages = EntityScanPackages.get((BeanFactory)this.context).getPackageNames();
            if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)this.context)) {
                packages = AutoConfigurationPackages.get((BeanFactory)this.context);
            }
            return packages;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class, Score.class})
    static class OptaPlannerJacksonConfiguration {
        OptaPlannerJacksonConfiguration() {
        }

        @Bean
        Module jacksonModule() {
            return OptaPlannerJacksonModule.createModule();
        }
    }
}

