/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.spring.boot.autoconfigure;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.core.base.CoreComponentsBuilder;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.solver.DefaultSolverManager;
import org.optaplanner.spring.boot.autoconfigure.OptaPlannerAutoConfiguration;
import org.optaplanner.spring.boot.autoconfigure.chained.ChainedSpringTestConfiguration;
import org.optaplanner.spring.boot.autoconfigure.chained.constraints.TestdataChainedSpringConstraintProvider;
import org.optaplanner.spring.boot.autoconfigure.chained.domain.TestdataChainedSpringEntity;
import org.optaplanner.spring.boot.autoconfigure.chained.domain.TestdataChainedSpringObject;
import org.optaplanner.spring.boot.autoconfigure.chained.domain.TestdataChainedSpringSolution;
import org.optaplanner.spring.boot.autoconfigure.gizmo.GizmoSpringTestConfiguration;
import org.optaplanner.spring.boot.autoconfigure.normal.NoConstraintsSpringTestConfiguration;
import org.optaplanner.spring.boot.autoconfigure.normal.NormalSpringTestConfiguration;
import org.optaplanner.spring.boot.autoconfigure.normal.constraints.TestdataSpringConstraintProvider;
import org.optaplanner.spring.boot.autoconfigure.normal.domain.TestdataSpringEntity;
import org.optaplanner.spring.boot.autoconfigure.normal.domain.TestdataSpringSolution;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultConstraintVerifier;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.autoconfigure.SpringBootDependencyInjectionTestExecutionListener;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.TestExecutionListeners;

@TestExecutionListeners(listeners={SpringBootDependencyInjectionTestExecutionListener.class})
public class OptaPlannerAutoConfigurationTest {
    private final ApplicationContextRunner contextRunner = (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{OptaPlannerAutoConfiguration.class}))).withUserConfiguration(new Class[]{NormalSpringTestConfiguration.class});
    private final ApplicationContextRunner noConstraintsContextRunner = (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{OptaPlannerAutoConfiguration.class}))).withUserConfiguration(new Class[]{NoConstraintsSpringTestConfiguration.class});
    private final ApplicationContextRunner chainedContextRunner;
    private final ApplicationContextRunner gizmoContextRunner = (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{OptaPlannerAutoConfiguration.class}))).withUserConfiguration(new Class[]{GizmoSpringTestConfiguration.class});
    private final FilteredClassLoader allDefaultsFilteredClassLoader;
    private final FilteredClassLoader testFilteredClassLoader;
    private final FilteredClassLoader noGizmoFilteredClassLoader;
    private final FilteredClassLoader defaultConstraintsDrlFilteredClassLoader;

    public OptaPlannerAutoConfigurationTest() {
        this.chainedContextRunner = (ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{OptaPlannerAutoConfiguration.class}))).withUserConfiguration(new Class[]{ChainedSpringTestConfiguration.class});
        this.allDefaultsFilteredClassLoader = new FilteredClassLoader(new Predicate[]{FilteredClassLoader.PackageFilter.of((String[])new String[]{"org.optaplanner.test"}), FilteredClassLoader.ClassPathResourceFilter.of((ClassPathResource[])new ClassPathResource[]{new ClassPathResource("solverConfig.xml")}), FilteredClassLoader.ClassPathResourceFilter.of((ClassPathResource[])new ClassPathResource[]{new ClassPathResource("constraints.drl")})});
        this.testFilteredClassLoader = new FilteredClassLoader(new ClassPathResource[]{new ClassPathResource("solverConfig.xml"), new ClassPathResource("constraints.drl")});
        this.defaultConstraintsDrlFilteredClassLoader = new FilteredClassLoader(new ClassPathResource[]{new ClassPathResource("constraints.drl")});
        this.noGizmoFilteredClassLoader = new FilteredClassLoader(new Predicate[]{FilteredClassLoader.PackageFilter.of((String[])new String[]{"io.quarkus.gizmo"}), FilteredClassLoader.ClassPathResourceFilter.of((ClassPathResource[])new ClassPathResource[]{new ClassPathResource("solverConfig.xml")}), FilteredClassLoader.ClassPathResourceFilter.of((ClassPathResource[])new ClassPathResource[]{new ClassPathResource("constraints.drl")})});
    }

    @Test
    public void solverConfigXml_none() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.allDefaultsFilteredClassLoader)).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).isEqualTo(Collections.singletonList(TestdataSpringEntity.class));
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataSpringConstraintProvider.class);
            Assertions.assertThat((Object)solverConfig.getTerminationConfig()).isNull();
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    public void solverConfigXml_default() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).isEqualTo(Collections.singletonList(TestdataSpringEntity.class));
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataSpringConstraintProvider.class);
            Assertions.assertThat((long)solverConfig.getTerminationConfig().getSecondsSpentLimit()).isEqualTo(2L);
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    public void solverConfigXml_property() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/customSpringBootSolverConfig.xml"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).isEqualTo(Collections.singletonList(TestdataSpringEntity.class));
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataSpringConstraintProvider.class);
            Assertions.assertThat((long)solverConfig.getTerminationConfig().getMinutesSpentLimit()).isEqualTo(3L);
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    public void solverProperties() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.environment-mode=FULL_ASSERT"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Comparable)solverConfig.getEnvironmentMode()).isEqualTo((Object)EnvironmentMode.FULL_ASSERT);
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
        ((ApplicationContextRunner)this.gizmoContextRunner.withPropertyValues(new String[]{"optaplanner.solver.domain-access-type=GIZMO"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Comparable)solverConfig.getDomainAccessType()).isEqualTo((Object)DomainAccessType.GIZMO);
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.daemon=true"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Boolean)solverConfig.getDaemon()).isTrue();
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.move-thread-count=2"})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((String)solverConfig.getMoveThreadCount()).isEqualTo("2");
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
    }

    @Test
    public void terminationProperties() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.termination.spent-limit=4h"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assertions.assertThat((Comparable)terminationConfig.getSpentLimit()).isEqualTo((Object)Duration.ofHours(4L));
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.termination.unimproved-spent-limit=5h"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assertions.assertThat((Comparable)terminationConfig.getUnimprovedSpentLimit()).isEqualTo((Object)Duration.ofHours(5L));
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.termination.best-score-limit=6"})).run(context -> {
            TerminationConfig terminationConfig = ((SolverConfig)context.getBean(SolverConfig.class)).getTerminationConfig();
            Assertions.assertThat((String)terminationConfig.getBestScoreLimit()).isEqualTo(SimpleScore.of((int)6).toString());
            Assertions.assertThat((Object)((SolverFactory)context.getBean(SolverFactory.class))).isNotNull();
        });
    }

    @Test
    public void singletonSolverFactory() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.defaultConstraintsDrlFilteredClassLoader)).run(context -> {
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            ScoreManager scoreManager = (ScoreManager)context.getBean(ScoreManager.class);
            Assertions.assertThat((Object)scoreManager).isNotNull();
            SolverManager solverManager = (SolverManager)context.getBean(SolverManager.class);
            Assertions.assertThat((Object)solverManager).isNotNull();
            Assertions.assertThat((Object)((DefaultSolverManager)solverManager).getSolverFactory()).isSameAs((Object)solverFactory);
        });
    }

    @Test
    public void solve() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.allDefaultsFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver.termination.best-score-limit=0"})).run(context -> {
            SolverManager solverManager = (SolverManager)context.getBean(SolverManager.class);
            TestdataSpringSolution problem = new TestdataSpringSolution();
            problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
            problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataSpringEntity()).collect(Collectors.toList()));
            SolverJob solverJob = solverManager.solve((Object)1L, (Object)problem);
            TestdataSpringSolution solution = (TestdataSpringSolution)solverJob.getFinalBestSolution();
            Assertions.assertThat((Object)solution).isNotNull();
            Assertions.assertThat((int)solution.getScore().getScore()).isGreaterThanOrEqualTo(0);
        });
    }

    @Test
    public void constraintVerifier() {
        ((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.testFilteredClassLoader)).run(context -> {
            ConstraintVerifier constraintVerifier = (ConstraintVerifier)context.getBean(ConstraintVerifier.class);
            Assertions.assertThat((Comparable)((DefaultConstraintVerifier)constraintVerifier).getConstraintStreamImplType()).isEqualTo((Object)ConstraintStreamImplType.DROOLS);
            Assertions.assertThat((boolean)((DefaultConstraintVerifier)constraintVerifier).isDroolsAlphaNetworkCompilationEnabled()).isEqualTo(!CoreComponentsBuilder.isNativeImage());
            TestdataSpringSolution problem = new TestdataSpringSolution();
            problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
            problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataSpringEntity()).collect(Collectors.toList()));
            problem.getEntityList().get(0).setValue("v1");
            problem.getEntityList().get(1).setValue("v1");
            constraintVerifier.verifyThat().givenSolution((Object)problem).scores((Score)SimpleScore.of((int)-2));
            problem.getEntityList().get(1).setValue("v2");
            constraintVerifier.verifyThat().givenSolution((Object)problem).scores((Score)SimpleScore.of((int)0));
        });
    }

    @Test
    public void constraintVerifierBavet() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withClassLoader((ClassLoader)this.testFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/bavetSolverConfig.xml"})).run(context -> {
            ConstraintVerifier constraintVerifier = (ConstraintVerifier)context.getBean(ConstraintVerifier.class);
            Assertions.assertThat((Comparable)((DefaultConstraintVerifier)constraintVerifier).getConstraintStreamImplType()).isEqualTo((Object)ConstraintStreamImplType.BAVET);
            Assertions.assertThat((boolean)((DefaultConstraintVerifier)constraintVerifier).isDroolsAlphaNetworkCompilationEnabled()).isFalse();
            TestdataSpringSolution problem = new TestdataSpringSolution();
            problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
            problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataSpringEntity()).collect(Collectors.toList()));
            problem.getEntityList().get(0).setValue("v1");
            problem.getEntityList().get(1).setValue("v1");
            constraintVerifier.verifyThat().givenSolution((Object)problem).scores((Score)SimpleScore.of((int)-2));
            problem.getEntityList().get(1).setValue("v2");
            constraintVerifier.verifyThat().givenSolution((Object)problem).scores((Score)SimpleScore.of((int)0));
        });
    }

    @Test
    public void constraintVerifierOnDrl() {
        String constraintsUrl = "org/optaplanner/spring/boot/autoconfigure/customConstraints.drl";
        ((ApplicationContextRunner)((ApplicationContextRunner)this.noConstraintsContextRunner.withPropertyValues(new String[]{"optaplanner.score-drl=" + constraintsUrl})).withClassLoader((ClassLoader)this.testFilteredClassLoader)).run(context -> Assertions.assertThatCode(() -> ((ConstraintVerifier)context.getBean(ConstraintVerifier.class)).verifyThat()).hasMessage("ConstraintVerifier is only supported for ConstraintProviders"));
    }

    @Test
    public void chained_solverConfigXml_none() {
        ((ApplicationContextRunner)this.chainedContextRunner.withClassLoader((ClassLoader)this.allDefaultsFilteredClassLoader)).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            Assertions.assertThat((Class)solverConfig.getSolutionClass()).isEqualTo(TestdataChainedSpringSolution.class);
            Assertions.assertThat((List)solverConfig.getEntityClassList()).containsExactlyInAnyOrder((Object[])new Class[]{TestdataChainedSpringObject.class, TestdataChainedSpringEntity.class});
            Assertions.assertThat((Class)solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass()).isEqualTo(TestdataChainedSpringConstraintProvider.class);
            Assertions.assertThat((Object)solverConfig.getTerminationConfig()).isNull();
            SolverFactory solverFactory = (SolverFactory)context.getBean(SolverFactory.class);
            Assertions.assertThat((Object)solverFactory).isNotNull();
            Assertions.assertThat((Object)solverFactory.buildSolver()).isNotNull();
        });
    }

    @Test
    void constraintsDrlProperty() {
        String constraintsUrl = "org/optaplanner/spring/boot/autoconfigure/customConstraints.drl";
        ((ApplicationContextRunner)this.noConstraintsContextRunner.withPropertyValues(new String[]{"optaplanner.score-drl=" + constraintsUrl})).run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            ((ListAssert)Assertions.assertThat((List)solverConfig.getScoreDirectorFactoryConfig().getScoreDrlList()).isNotNull()).containsExactly((Object[])new String[]{constraintsUrl});
        });
    }

    @Test
    void constraintsDrlDefault() {
        this.noConstraintsContextRunner.run(context -> {
            SolverConfig solverConfig = (SolverConfig)context.getBean(SolverConfig.class);
            Assertions.assertThat((Object)solverConfig).isNotNull();
            ((ListAssert)Assertions.assertThat((List)solverConfig.getScoreDirectorFactoryConfig().getScoreDrlList()).isNotNull()).containsExactly((Object[])new String[]{"constraints.drl"});
        });
    }

    @Test
    void constraintsDrlProperty_conflictWithConstraintProvider() {
        String constraintsUrl = "org/optaplanner/spring/boot/autoconfigure/customConstraints.drl";
        ((ApplicationContextRunner)this.contextRunner.withPropertyValues(new String[]{"optaplanner.score-drl=" + constraintsUrl})).run(context -> Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> context.getBean(SolverConfig.class)).withStackTraceContaining("The scoreDirectorFactory cannot have a constraintProviderClass (" + TestdataSpringConstraintProvider.class.getName() + ") and a scoreDrlList (" + constraintsUrl + ")"));
    }

    @Test
    void customScoreDrl_overrides_solverConfig() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"config_constraints.drl"});
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerAutoConfiguration autoConfiguration = this.mockAutoConfiguration();
        Mockito.when((Object)autoConfiguration.constraintsDrl()).thenReturn((Object)"some.drl");
        autoConfiguration.applyScoreDirectorFactoryProperties(solverConfig);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"some.drl"});
    }

    @Test
    void defaultScoreDrl_does_not_override_solverConfig() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"config_constraints.drl"});
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerAutoConfiguration autoConfiguration = this.mockAutoConfiguration();
        Mockito.when((Object)autoConfiguration.constraintsDrl()).thenReturn(null);
        Mockito.when((Object)autoConfiguration.defaultConstraintsDrl()).thenReturn((Object)"constraints.drl");
        autoConfiguration.applyScoreDirectorFactoryProperties(solverConfig);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"config_constraints.drl"});
    }

    @Test
    void defaultScoreDrl_applies_if_solverConfig_does_not_define_scoreDrl() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerAutoConfiguration autoConfiguration = this.mockAutoConfiguration();
        Mockito.when((Object)autoConfiguration.constraintsDrl()).thenReturn(null);
        Mockito.when((Object)autoConfiguration.defaultConstraintsDrl()).thenReturn((Object)"constraints.drl");
        autoConfiguration.applyScoreDirectorFactoryProperties(solverConfig);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"constraints.drl"});
    }

    @Test
    @Disabled(value="Test works when run by itself, but errors when run in suite; it appears it still find the class when run in a suite, but not alone.")
    void gizmo_throws_if_gizmo_not_present() {
        Assertions.assertThatCode(() -> ((ApplicationContextRunner)((ApplicationContextRunner)this.gizmoContextRunner.withClassLoader((ClassLoader)this.noGizmoFilteredClassLoader)).withPropertyValues(new String[]{"optaplanner.solver-config-xml=org/optaplanner/spring/boot/autoconfigure/gizmoSpringBootSolverConfig.xml"})).run(context -> context.getBean(SolverFactory.class))).hasRootCauseMessage("When using the domainAccessType (" + DomainAccessType.GIZMO + ") the classpath or modulepath must contain io.quarkus.gizmo:gizmo.\nMaybe add a dependency to io.quarkus.gizmo:gizmo.");
    }

    private OptaPlannerAutoConfiguration mockAutoConfiguration() {
        OptaPlannerAutoConfiguration autoConfiguration = (OptaPlannerAutoConfiguration)Mockito.mock(OptaPlannerAutoConfiguration.class);
        ((OptaPlannerAutoConfiguration)Mockito.doCallRealMethod().when((Object)autoConfiguration)).applyScoreDirectorFactoryProperties((SolverConfig)ArgumentMatchers.any());
        return autoConfiguration;
    }
}

