/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.base.ClassTypeResolver;
import org.kie.workbench.common.services.backend.project.ProjectClassLoaderHelper;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScoreHolder;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScoreHolder;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScoreHolder;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScore;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScoreHolder;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScoreHolder;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class ScoreHolderUtils {
    private static final Pattern ABSTRACT_SOLUTION_PATTERN = Pattern.compile("[\\w+\\.]*AbstractSolution<([\\w+\\.]*\\w+)>");
    private KieProjectService kieProjectService;
    private ProjectClassLoaderHelper classLoaderHelper;

    public ScoreHolderUtils() {
    }

    @Inject
    public ScoreHolderUtils(KieProjectService kieProjectService, ProjectClassLoaderHelper classLoaderHelper) {
        this.kieProjectService = kieProjectService;
        this.classLoaderHelper = classLoaderHelper;
    }

    public String extractScoreTypeFqn(DataObject dataObject, Path dataObjectPath) {
        Matcher matcher = ABSTRACT_SOLUTION_PATTERN.matcher(dataObject.getSuperClassName());
        if (matcher.matches()) {
            String scoreTypeFqn;
            String scoreType = matcher.group(1);
            if (scoreType.contains(".")) {
                scoreTypeFqn = scoreType;
            } else {
                KieProject kieProject = (KieProject)this.kieProjectService.resolveProject(dataObjectPath);
                Set imports = dataObject.getImports().stream().map(i -> i.getName()).collect(Collectors.toSet());
                ClassLoader projectClassLoader = this.classLoaderHelper.getProjectClassLoader(kieProject);
                ClassTypeResolver classTypeResolver = new ClassTypeResolver(imports, projectClassLoader);
                try {
                    scoreTypeFqn = classTypeResolver.getFullTypeName(scoreType);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return scoreTypeFqn;
        }
        return null;
    }

    public String getScoreHolderTypeFqn(String scoreTypeFqn) {
        if (BendableScore.class.getName().equals(scoreTypeFqn)) {
            return BendableScoreHolder.class.getName();
        }
        if (BendableBigDecimalScore.class.getName().equals(scoreTypeFqn)) {
            return BendableBigDecimalScoreHolder.class.getName();
        }
        if (BendableLongScore.class.getName().equals(scoreTypeFqn)) {
            return BendableLongScoreHolder.class.getName();
        }
        if (HardMediumSoftScore.class.getName().equals(scoreTypeFqn)) {
            return HardMediumSoftScoreHolder.class.getName();
        }
        if (HardMediumSoftBigDecimalScore.class.getName().equals(scoreTypeFqn)) {
            return HardMediumSoftBigDecimalScoreHolder.class.getName();
        }
        if (HardMediumSoftLongScore.class.getName().equals(scoreTypeFqn)) {
            return HardMediumSoftLongScoreHolder.class.getName();
        }
        if (HardSoftScore.class.getName().equals(scoreTypeFqn)) {
            return HardSoftScoreHolder.class.getName();
        }
        if (HardSoftBigDecimalScore.class.getName().equals(scoreTypeFqn)) {
            return HardSoftBigDecimalScoreHolder.class.getName();
        }
        if (HardSoftDoubleScore.class.getName().equals(scoreTypeFqn)) {
            return HardSoftDoubleScoreHolder.class.getName();
        }
        if (HardSoftLongScore.class.getName().equals(scoreTypeFqn)) {
            return HardSoftLongScoreHolder.class.getName();
        }
        if (SimpleScore.class.getName().equals(scoreTypeFqn)) {
            return SimpleScoreHolder.class.getName();
        }
        if (SimpleBigDecimalScore.class.getName().equals(scoreTypeFqn)) {
            return SimpleBigDecimalScoreHolder.class.getName();
        }
        if (SimpleDoubleScore.class.getName().equals(scoreTypeFqn)) {
            return SimpleDoubleScoreHolder.class.getName();
        }
        if (SimpleLongScore.class.getName().equals(scoreTypeFqn)) {
            return SimpleLongScoreHolder.class.getName();
        }
        return null;
    }
}

