/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.PlanningSolutionSaveValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionSaveValidatorTest {
    @Mock
    private AssetsUsageService assetsUsageService;
    private PlanningSolutionSaveValidator saveValidator;

    @Before
    public void setUp() {
        this.saveValidator = new PlanningSolutionSaveValidator(this.assetsUsageService);
    }

    @Test
    public void accept() {
        Path dataObjectPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)dataObjectPath.toURI()).thenReturn((Object)"file:///project/Test.java");
        Mockito.when((Object)dataObjectPath.getFileName()).thenReturn((Object)"Test.java");
        Assert.assertTrue((boolean)this.saveValidator.accept(dataObjectPath));
        Path propertiesPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)propertiesPath.getFileName()).thenReturn((Object)"Test.properties");
        Assert.assertFalse((boolean)this.saveValidator.accept(propertiesPath));
    }

    @Test
    public void checkDataObjectIsNull() {
        Collection result = this.saveValidator.validate((Path)Mockito.mock(Path.class), null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void checkNotAPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        Collection result = this.saveValidator.validate((Path)Mockito.mock(Path.class), (DataObject)dataObject);
        Assert.assertTrue((boolean)result.isEmpty());
        ((AssetsUsageService)Mockito.verify((Object)this.assetsUsageService, (VerificationMode)Mockito.never())).getAssetUsages((String)Matchers.any(), (ResourceType)Matchers.any(), (Path)Matchers.any());
    }

    @Test
    public void checkPlanningSolutionNoOtherExists() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        Path dataObjectPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(PlanningSolution.class.getName(), ResourceType.JAVA, dataObjectPath)).thenReturn(Arrays.asList(dataObjectPath));
        Collection result = this.saveValidator.validate(dataObjectPath, (DataObject)dataObject);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void checkPlanningSolutionNoOtherExistsFirstSave() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        Path dataObjectPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(PlanningSolution.class.getName(), ResourceType.JAVA, dataObjectPath)).thenReturn(Collections.emptyList());
        Collection result = this.saveValidator.validate(dataObjectPath, (DataObject)dataObject);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void checkPlanningSolutionOtherExists() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        Path dataObjectPath = (Path)Mockito.mock(Path.class);
        Path otherDataObjectPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(PlanningSolution.class.getName(), ResourceType.JAVA, dataObjectPath)).thenReturn(Arrays.asList(otherDataObjectPath));
        Collection result = this.saveValidator.validate(dataObjectPath, (DataObject)dataObject);
        Assert.assertEquals((long)1L, (long)result.size());
        ValidationMessage message = (ValidationMessage)result.iterator().next();
        Assert.assertTrue((boolean)(message instanceof PlanningSolutionToBeDuplicatedMessage));
    }
}

